/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.surefire.osgibooter;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.tycho.surefire.osgibooter.OsgiSurefireBooter;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.testing.ITestHarness;
import org.eclipse.ui.testing.TestableObject;

public abstract class AbstractUITestApplication
implements ITestHarness {
    private static final String DEFAULT_APP_3_0 = "org.eclipse.ui.ide.workbench";
    private int fTestRunnerResult = -1;
    private String[] fArgs = new String[0];
    private TestableObject fTestableObject;

    public void runTests() {
        this.fTestableObject.testingStarting();
        if (this.useUIThread(this.fArgs)) {
            this.fTestableObject.runTest(new Runnable(){

                public void run() {
                    try {
                        AbstractUITestApplication.this.fTestRunnerResult = OsgiSurefireBooter.run(AbstractUITestApplication.this.fArgs);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        } else {
            try {
                this.fTestRunnerResult = OsgiSurefireBooter.run(this.fArgs);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.fTestableObject.testingFinished();
    }

    private boolean useUIThread(String[] args) {
        if (args != null) {
            int i = 0;
            while (i < args.length) {
                if ("-nouithread".equals(args[i])) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private Object getApplication(String[] args) throws CoreException {
        IConfigurationElement[] runs;
        IExtension extension = Platform.getExtensionRegistry().getExtension("org.eclipse.core.runtime", "applications", this.getApplicationToRun(args));
        if (extension == null) {
            return null;
        }
        IConfigurationElement[] elements = extension.getConfigurationElements();
        if (elements.length > 0 && (runs = elements[0].getChildren("run")).length > 0) {
            return runs[0].createExecutableExtension("class");
        }
        return null;
    }

    private String getApplicationToRun(String[] args) {
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-testApplication") && i < args.length - 1) {
                return args[i + 1];
            }
            ++i;
        }
        return DEFAULT_APP_3_0;
    }

    protected Object run(String[] args) throws Exception {
        if (args != null) {
            this.fArgs = args;
        }
        this.fTestableObject = PlatformUI.getTestableObject();
        this.fTestableObject.setTestHarness((ITestHarness)this);
        Object application = this.getApplication(args);
        this.runApplication(application, args);
        return new Integer(this.fTestRunnerResult);
    }

    protected abstract void runApplication(Object var1, String[] var2) throws Exception;
}

