/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.discovery;

import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.junit.jupiter.api.MethodDescriptor;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.MethodOrdererContext;
import org.junit.jupiter.api.TestMethodOrder;
import org.junit.jupiter.engine.config.JupiterConfiguration;
import org.junit.jupiter.engine.descriptor.ClassBasedTestDescriptor;
import org.junit.jupiter.engine.descriptor.JupiterTestDescriptor;
import org.junit.jupiter.engine.descriptor.MethodBasedTestDescriptor;
import org.junit.jupiter.engine.discovery.AbstractOrderingVisitor;
import org.junit.jupiter.engine.discovery.DefaultMethodDescriptor;
import org.junit.jupiter.engine.discovery.DefaultMethodOrdererContext;
import org.junit.platform.commons.support.AnnotationSupport;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.engine.TestDescriptor;

class MethodOrderingVisitor
extends AbstractOrderingVisitor<ClassBasedTestDescriptor, MethodBasedTestDescriptor, DefaultMethodDescriptor> {
    private final JupiterConfiguration configuration;

    MethodOrderingVisitor(JupiterConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void visit(TestDescriptor testDescriptor) {
        this.doWithMatchingDescriptor(ClassBasedTestDescriptor.class, testDescriptor, descriptor -> this.orderContainedMethods((ClassBasedTestDescriptor)descriptor, descriptor.getTestClass()), descriptor -> "Failed to order methods for " + descriptor.getTestClass());
    }

    private void orderContainedMethods(ClassBasedTestDescriptor classBasedTestDescriptor, Class<?> testClass) {
        AnnotationSupport.findAnnotation(testClass, TestMethodOrder.class).map(TestMethodOrder::value).map(x$0 -> (MethodOrderer)ReflectionUtils.newInstance(x$0, new Object[0])).map(Optional::of).orElseGet(this.configuration::getDefaultTestMethodOrderer).ifPresent(methodOrderer -> {
            Consumer orderingAction = methodDescriptors -> methodOrderer.orderMethods((MethodOrdererContext)new DefaultMethodOrdererContext(testClass, (List<? extends MethodDescriptor>)methodDescriptors, this.configuration));
            AbstractOrderingVisitor.MessageGenerator descriptorsAddedMessageGenerator = number -> String.format("MethodOrderer [%s] added %s MethodDescriptor(s) for test class [%s] which will be ignored.", methodOrderer.getClass().getName(), number, testClass.getName());
            AbstractOrderingVisitor.MessageGenerator descriptorsRemovedMessageGenerator = number -> String.format("MethodOrderer [%s] removed %s MethodDescriptor(s) for test class [%s] which will be retained with arbitrary ordering.", methodOrderer.getClass().getName(), number, testClass.getName());
            AbstractOrderingVisitor.DescriptorWrapperOrderer descriptorWrapperOrderer = new AbstractOrderingVisitor.DescriptorWrapperOrderer(this, orderingAction, descriptorsAddedMessageGenerator, descriptorsRemovedMessageGenerator);
            this.orderChildrenTestDescriptors(classBasedTestDescriptor, MethodBasedTestDescriptor.class, DefaultMethodDescriptor::new, descriptorWrapperOrderer);
            methodOrderer.getDefaultExecutionMode().map(JupiterTestDescriptor::toExecutionMode).ifPresent(classBasedTestDescriptor::setDefaultChildExecutionMode);
        });
    }
}

