/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitcore.pc;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.maven.surefire.junitcore.pc.InvokerStrategy;
import org.apache.maven.surefire.junitcore.pc.NonSharedThreadPoolStrategy;
import org.apache.maven.surefire.junitcore.pc.SchedulingStrategy;
import org.apache.maven.surefire.junitcore.pc.SharedThreadPoolStrategy;
import org.apache.maven.surefire.report.ConsoleStream;
import org.apache.maven.surefire.util.internal.DaemonThreadFactory;

public class SchedulingStrategies {
    private static final ThreadFactory DAEMON_THREAD_FACTORY = DaemonThreadFactory.newDaemonThreadFactory();

    public static SchedulingStrategy createInvokerStrategy(ConsoleStream logger) {
        return new InvokerStrategy(logger);
    }

    public static SchedulingStrategy createParallelStrategy(ConsoleStream logger, int nThreads) {
        return new NonSharedThreadPoolStrategy(logger, Executors.newFixedThreadPool(nThreads, DAEMON_THREAD_FACTORY));
    }

    public static SchedulingStrategy createParallelStrategyUnbounded(ConsoleStream logger) {
        return new NonSharedThreadPoolStrategy(logger, Executors.newCachedThreadPool(DAEMON_THREAD_FACTORY));
    }

    public static SchedulingStrategy createParallelSharedStrategy(ConsoleStream logger, ExecutorService threadPool) {
        if (threadPool == null) {
            throw new NullPointerException("null threadPool in #createParallelSharedStrategy");
        }
        return new SharedThreadPoolStrategy(logger, threadPool);
    }
}

