/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.extras.sourceref.jgit;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.errors.AmbiguousObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.tycho.packaging.sourceref.ScmUrl;
import org.eclipse.tycho.packaging.sourceref.SourceReferencesProvider;

@Component(role=SourceReferencesProvider.class, hint="git")
public class JGitSourceReferencesProvider
implements SourceReferencesProvider {
    public String getSourceReferencesHeader(MavenProject project, ScmUrl scmUrl) throws MojoExecutionException {
        Git git;
        Repository repo;
        File basedir = project.getBasedir().getAbsoluteFile();
        FileRepositoryBuilder builder = (FileRepositoryBuilder)((FileRepositoryBuilder)((FileRepositoryBuilder)new FileRepositoryBuilder().readEnvironment()).findGitDir(basedir)).setMustExist(true);
        try {
            repo = builder.build();
            git = Git.wrap((Repository)repo);
        }
        catch (IOException e) {
            throw new MojoExecutionException("IO exception trying to create git repo ", (Exception)e);
        }
        ObjectId head = this.resolveHead(repo);
        StringBuilder result = new StringBuilder(scmUrl.getUrl());
        result.append(";path=\"");
        result.append(this.getRelativePath(basedir, repo.getWorkTree()));
        result.append("\"");
        String tag = this.findTagForHead(git, head);
        if (tag != null) {
            result.append(";tag=\"");
            result.append(tag);
            result.append("\"");
        }
        result.append(";commitId=");
        result.append(head.getName());
        return result.toString();
    }

    private ObjectId resolveHead(Repository repo) throws MojoExecutionException {
        ObjectId head;
        try {
            head = repo.resolve("HEAD");
        }
        catch (AmbiguousObjectException e) {
            throw new MojoExecutionException("exception trying resolve HEAD", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new MojoExecutionException("exception trying resolve HEAD", (Exception)e);
        }
        return head;
    }

    private String findTagForHead(Git git, ObjectId head) throws MojoExecutionException {
        String tag = null;
        try {
            for (Ref ref : git.tagList().call()) {
                ObjectId objectId = ref.getPeeledObjectId();
                if (objectId == null) {
                    objectId = ref.getObjectId();
                }
                if (!head.equals((AnyObjectId)objectId)) continue;
                tag = ref.getName();
                if (tag.startsWith("refs/tags/")) {
                    tag = tag.substring("refs/tags/".length());
                }
                break;
            }
        }
        catch (GitAPIException e) {
            throw new MojoExecutionException("exception trying to get tag list", (Exception)((Object)e));
        }
        return tag;
    }

    String getRelativePath(File subDir, File parentDir) throws MojoExecutionException {
        URI relativeUri;
        URI subDirUri;
        try {
            subDirUri = subDir.getCanonicalFile().toURI();
            relativeUri = parentDir.getCanonicalFile().toURI().relativize(subDirUri);
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        if (relativeUri.equals(subDirUri)) {
            throw new MojoExecutionException(subDir + " is not a subdir of " + parentDir);
        }
        String relative = relativeUri.getPath();
        if (relative.startsWith("/")) {
            relative = relative.substring(1);
        }
        if (relative.endsWith("/")) {
            relative = relative.substring(0, relative.length() - 1);
        }
        return relative;
    }
}

