/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.extras.sourcefeature;

import de.pdark.decentxml.Document;
import de.pdark.decentxml.Element;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.archiver.MavenArchiveConfiguration;
import org.apache.maven.archiver.MavenArchiver;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.FileSet;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.util.DefaultFileSet;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.IOUtil;
import org.eclipse.sisu.equinox.EquinoxServiceFactory;
import org.eclipse.tycho.artifacts.TargetPlatform;
import org.eclipse.tycho.core.facade.MavenLogger;
import org.eclipse.tycho.core.osgitools.DebugUtils;
import org.eclipse.tycho.core.utils.TychoProjectUtils;
import org.eclipse.tycho.model.Feature;
import org.eclipse.tycho.model.FeatureRef;
import org.eclipse.tycho.model.PluginRef;
import org.eclipse.tycho.osgi.adapters.MavenLoggerAdapter;
import org.eclipse.tycho.p2.resolver.facade.P2ResolutionResult;
import org.eclipse.tycho.p2.resolver.facade.P2Resolver;
import org.eclipse.tycho.p2.resolver.facade.P2ResolverFactory;
import org.eclipse.tycho.packaging.LicenseFeatureHelper;

@Mojo(name="source-feature", defaultPhase=LifecyclePhase.PACKAGE)
public class SourceFeatureMojo
extends AbstractMojo {
    public static final String FEATURE_TEMPLATE_DIR = "sourceTemplateFeature";
    public static final String SOURCES_FEATURE_CLASSIFIER = "sources-feature";
    private static final String FEATURE_PROPERTIES = "feature.properties";
    private static final String GEN_DIR = "sources-feature";
    @Parameter(property="project", readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="false")
    private boolean skip;
    @Parameter(defaultValue="true")
    private boolean includeBinaryFeature;
    @Parameter(defaultValue=" Developer Resources")
    private String labelSuffix;
    @Parameter
    private String brandingPlugin;
    @Parameter(defaultValue="true")
    private boolean reuseBrandingPlugin;
    @Parameter
    private PlexusConfiguration excludes;
    @Parameter
    private PlexusConfiguration plugins;
    @Parameter(property="session", readonly=true)
    private MavenSession session;
    private final Set<String> excludedPlugins = new HashSet<String>();
    private final Set<String> excludedFeatures = new HashSet<String>();
    private final Set<PluginRef> extraPlugins = new HashSet<PluginRef>();
    @Parameter
    private MavenArchiveConfiguration archive = new MavenArchiveConfiguration();
    @Parameter(property="project.build.finalName")
    private String finalName;
    @Component(role=Archiver.class, hint="jar")
    private JarArchiver jarArchiver;
    @Component
    private MavenProjectHelper projectHelper;
    @Component
    private LicenseFeatureHelper licenseFeatureHelper;
    @Component
    private EquinoxServiceFactory equinox;
    @Component
    private Logger logger;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!"eclipse-feature".equals(this.project.getPackaging()) || this.skip) {
            return;
        }
        try {
            Properties sourceFeatureTemplateProps = this.readSourceTemplateFeatureProperties();
            Properties mergedSourceFeatureProps = this.mergeFeatureProperties(sourceFeatureTemplateProps);
            File sourceFeatureXml = this.generateSourceFeatureXml(mergedSourceFeatureProps, sourceFeatureTemplateProps);
            SourceFeatureMojo.writeProperties(mergedSourceFeatureProps, this.getMergedSourceFeaturePropertiesFile());
            MavenArchiver archiver = new MavenArchiver();
            archiver.setArchiver(this.jarArchiver);
            File outputJarFile = this.getOutputJarFile();
            archiver.setOutputFile(outputJarFile);
            File template = new File(this.project.getBasedir(), FEATURE_TEMPLATE_DIR);
            if (template.isDirectory()) {
                DefaultFileSet templateFileSet = new DefaultFileSet();
                templateFileSet.setDirectory(template);
                templateFileSet.setExcludes(new String[]{"feature.xml", FEATURE_PROPERTIES});
                archiver.getArchiver().addFileSet((FileSet)templateFileSet);
            }
            archiver.getArchiver().addFile(sourceFeatureXml, "feature.xml");
            archiver.getArchiver().addFile(this.getMergedSourceFeaturePropertiesFile(), FEATURE_PROPERTIES);
            File licenseFeature = this.licenseFeatureHelper.getLicenseFeature(Feature.read((File)new File(this.project.getBasedir(), "feature.xml")), this.project);
            if (licenseFeature != null) {
                archiver.getArchiver().addArchivedFileSet(this.licenseFeatureHelper.getLicenseFeatureFileSet(licenseFeature));
            }
            archiver.createArchive(this.project, this.archive);
            this.projectHelper.attachArtifact(this.project, outputJarFile, "sources-feature");
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Could not package source feature jar", e);
        }
    }

    static File getSourcesFeatureOutputDir(MavenProject project) {
        File dir = new File(project.getBuild().getDirectory(), "sources-feature");
        dir.mkdirs();
        new File(dir, "p2.inf").delete();
        return dir;
    }

    private Properties mergeFeatureProperties(Properties sourceFeatureTemplateProps) throws IOException {
        Properties generatedOriginalFeatureProps = SourceFeatureMojo.readPropertiesIfExists(new File(this.project.getBuild().getDirectory(), FEATURE_PROPERTIES));
        Properties mergedProperties = new Properties();
        mergedProperties.putAll((Map<?, ?>)generatedOriginalFeatureProps);
        mergedProperties.putAll((Map<?, ?>)sourceFeatureTemplateProps);
        return mergedProperties;
    }

    private Properties readSourceTemplateFeatureProperties() throws IOException {
        return SourceFeatureMojo.readPropertiesIfExists(new File(this.project.getBasedir(), "sourceTemplateFeature/feature.properties"));
    }

    private File generateSourceFeatureXml(Properties mergedSourceFeatureProps, Properties sourceTemplateProps) throws IOException, MojoExecutionException {
        File sourceFeatureXml = new File(SourceFeatureMojo.getSourcesFeatureOutputDir(this.project), "feature.xml");
        Feature feature = Feature.read((File)new File(this.project.getBuild().getDirectory(), "feature.xml"));
        Feature sourceFeature = this.createSourceFeatureSkeleton(feature, mergedSourceFeatureProps, sourceTemplateProps);
        this.fillReferences(sourceFeature, feature, TychoProjectUtils.getTargetPlatform((MavenProject)this.project));
        Feature.write((Feature)sourceFeature, (File)sourceFeatureXml, (String)"  ");
        return sourceFeatureXml;
    }

    private File getMergedSourceFeaturePropertiesFile() {
        return new File(SourceFeatureMojo.getSourcesFeatureOutputDir(this.project), FEATURE_PROPERTIES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties readPropertiesIfExists(File propertiesFile) throws IOException {
        Properties properties = new Properties();
        if (propertiesFile.isFile()) {
            FileInputStream propertiesStream = null;
            try {
                propertiesStream = new FileInputStream(propertiesFile);
                properties.load(propertiesStream);
            }
            catch (Throwable throwable) {
                IOUtil.close(propertiesStream);
                throw throwable;
            }
            IOUtil.close((InputStream)propertiesStream);
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeProperties(Properties props, File propertiesFile) throws IOException {
        propertiesFile.getParentFile().mkdirs();
        FileOutputStream out = new FileOutputStream(propertiesFile);
        try {
            props.save(out, "");
        }
        finally {
            IOUtil.close((OutputStream)out);
        }
    }

    Feature createSourceFeatureSkeleton(Feature feature, Properties mergedFeatureProperties, Properties sourceTemplateProperties) throws IOException, MojoExecutionException {
        Document document = new Document();
        document.setEncoding("UTF-8");
        document.setRootNode(new Element("feature"));
        Feature sourceFeature = new Feature(document);
        sourceFeature.setId(feature.getId() + ".source");
        sourceFeature.setVersion(feature.getVersion());
        if (this.reuseBrandingPlugin && this.brandingPlugin == null) {
            if (feature.getBrandingPluginId() != null) {
                sourceFeature.setBrandingPluginId(feature.getBrandingPluginId());
            }
        } else if (this.brandingPlugin != null) {
            sourceFeature.setBrandingPluginId(this.brandingPlugin);
        }
        if (this.includeBinaryFeature) {
            FeatureRef binaryRef = new FeatureRef(new Element("includes"));
            binaryRef.setId(feature.getId());
            binaryRef.setVersion(feature.getVersion());
            if (feature.getOS() != null) {
                binaryRef.setOS(feature.getOS());
            }
            if (feature.getWS() != null) {
                binaryRef.setWS(feature.getWS());
            }
            if (feature.getArch() != null) {
                binaryRef.setArch(feature.getArch());
            }
            sourceFeature.addFeatureRef(binaryRef);
        }
        if (feature.getLabel() != null) {
            String originalLabel = feature.getLabel();
            if (originalLabel.startsWith("%")) {
                sourceFeature.setLabel(SourceFeatureMojo.validateValue(originalLabel, mergedFeatureProperties));
                String labelKey = originalLabel.substring(1);
                if (sourceTemplateProperties.getProperty(labelKey) == null) {
                    mergedFeatureProperties.setProperty(labelKey, mergedFeatureProperties.getProperty(labelKey) + this.labelSuffix);
                }
            } else {
                sourceFeature.setLabel(originalLabel + this.labelSuffix);
            }
        }
        if (feature.getProvider() != null) {
            sourceFeature.setProvider(SourceFeatureMojo.validateValue(feature.getProvider(), mergedFeatureProperties));
        }
        if (feature.getDescription() != null) {
            sourceFeature.setDescription(SourceFeatureMojo.validateValue(feature.getDescription(), mergedFeatureProperties));
        }
        if (feature.getDescriptionURL() != null) {
            sourceFeature.setDescriptionURL(SourceFeatureMojo.validateValue(feature.getDescriptionURL(), mergedFeatureProperties));
        }
        if (feature.getCopyright() != null) {
            sourceFeature.setCopyright(SourceFeatureMojo.validateValue(feature.getCopyright(), mergedFeatureProperties));
        }
        if (feature.getCopyrightURL() != null) {
            sourceFeature.setCopyrightURL(SourceFeatureMojo.validateValue(feature.getCopyrightURL(), mergedFeatureProperties));
        }
        if (feature.getLicense() != null) {
            sourceFeature.setLicense(SourceFeatureMojo.validateValue(feature.getLicense(), mergedFeatureProperties));
        }
        if (feature.getLicenseURL() != null) {
            sourceFeature.setLicenseURL(SourceFeatureMojo.validateValue(feature.getLicenseURL(), mergedFeatureProperties));
        }
        return sourceFeature;
    }

    private static String validateValue(String fieldValue, Properties sourceFeatureProperties) throws MojoExecutionException {
        String key;
        if (fieldValue.startsWith("%") && !sourceFeatureProperties.containsKey(key = fieldValue.substring(1))) {
            throw new MojoExecutionException("Source feature depends on 'sourceTemplateFeature/feature.properties', entry '" + key + "'. However, this key could not be found");
        }
        return fieldValue;
    }

    private void fillReferences(Feature sourceFeature, Feature feature, TargetPlatform targetPlatform) throws MojoExecutionException {
        P2ResolutionResult result;
        P2ResolverFactory factory = (P2ResolverFactory)this.equinox.getService(P2ResolverFactory.class);
        P2Resolver p2 = factory.createResolver((MavenLogger)new MavenLoggerAdapter(this.logger, DebugUtils.isDebugEnabled((MavenSession)this.session, (MavenProject)this.project)));
        ArrayList<PluginRef> missingSourcePlugins = new ArrayList<PluginRef>();
        ArrayList<FeatureRef> missingSourceFeatures = new ArrayList<FeatureRef>();
        ArrayList<PluginRef> missingExtraPlugins = new ArrayList<PluginRef>();
        for (PluginRef pluginRef : feature.getPlugins()) {
            if (this.excludedPlugins.contains(pluginRef.getId())) continue;
            result = p2.resolveInstallableUnit(targetPlatform, pluginRef.getId() + ".source", this.toStrictVersionRange(pluginRef.getVersion()));
            if (result.getArtifacts().size() == 1) {
                this.addPlugin(sourceFeature, result, pluginRef);
                continue;
            }
            missingSourcePlugins.add(pluginRef);
        }
        for (FeatureRef featureRef : feature.getIncludedFeatures()) {
            if (this.excludedFeatures.contains(featureRef.getId())) continue;
            String sourceId = featureRef.getId() + ".source";
            P2ResolutionResult result2 = p2.resolveInstallableUnit(targetPlatform, sourceId + ".feature.jar", this.toStrictVersionRange(featureRef.getVersion()));
            if (result2.getArtifacts().size() == 1) {
                P2ResolutionResult.Entry entry = (P2ResolutionResult.Entry)result2.getArtifacts().iterator().next();
                FeatureRef sourceRef = new FeatureRef(new Element("includes"));
                sourceRef.setId(sourceId);
                sourceRef.setVersion(entry.getVersion());
                sourceFeature.addFeatureRef(sourceRef);
                continue;
            }
            missingSourceFeatures.add(featureRef);
        }
        for (PluginRef pluginRef : this.extraPlugins) {
            result = p2.resolveInstallableUnit(targetPlatform, pluginRef.getId(), pluginRef.getVersion());
            if (result.getArtifacts().size() == 1) {
                this.addPlugin(sourceFeature, result, pluginRef);
                continue;
            }
            missingExtraPlugins.add(pluginRef);
        }
        if (!(missingSourceFeatures.isEmpty() && missingSourcePlugins.isEmpty() && missingExtraPlugins.isEmpty())) {
            StringBuilder sb = new StringBuilder();
            sb.append("Could not generate source feature for project " + this.project.toString()).append("\n");
            if (!missingSourcePlugins.isEmpty()) {
                sb.append("    Missing sources for plugins " + ((Object)missingSourcePlugins).toString()).append("\n");
            }
            if (!missingSourceFeatures.isEmpty()) {
                sb.append("    Missing sources for features " + ((Object)missingSourceFeatures).toString()).append("\n");
            }
            if (!missingExtraPlugins.isEmpty()) {
                sb.append("    Missing extra plugins " + ((Object)missingExtraPlugins).toString()).append("\n");
            }
            throw new MojoExecutionException(sb.toString());
        }
    }

    protected String toStrictVersionRange(String version) {
        return "[" + version + "," + version + "]";
    }

    protected void addPlugin(Feature sourceFeature, P2ResolutionResult result, PluginRef pluginRef) {
        P2ResolutionResult.Entry sourceBundle = (P2ResolutionResult.Entry)result.getArtifacts().iterator().next();
        PluginRef sourceRef = new PluginRef("plugin");
        sourceRef.setId(sourceBundle.getId());
        sourceRef.setVersion(sourceBundle.getVersion());
        sourceRef.setDownloadSide(0L);
        sourceRef.setInstallSize(0L);
        if (pluginRef.getOs() != null) {
            sourceRef.setOs(pluginRef.getOs());
        }
        if (pluginRef.getWs() != null) {
            sourceRef.setWs(pluginRef.getWs());
        }
        if (pluginRef.getArch() != null) {
            sourceRef.setArch(pluginRef.getArch());
        }
        sourceRef.setUnpack(false);
        sourceFeature.addPlugin(sourceRef);
    }

    protected File getOutputJarFile() {
        String filename = this.finalName + "-" + "sources-feature" + ".jar";
        return new File(this.project.getBuild().getDirectory(), filename);
    }

    public void setExcludes(PlexusConfiguration excludes) {
        String id;
        for (PlexusConfiguration plugin : excludes.getChildren("plugin")) {
            id = this.getAttribute(plugin, "id");
            if (id == null) continue;
            this.excludedPlugins.add(id);
        }
        for (PlexusConfiguration plugin : excludes.getChildren("feature")) {
            id = this.getAttribute(plugin, "id");
            if (id == null) continue;
            this.excludedFeatures.add(id);
        }
    }

    public void setPlugins(PlexusConfiguration bundles) {
        for (PlexusConfiguration plugin : bundles.getChildren("plugin")) {
            String id = this.getAttribute(plugin, "id");
            if (id == null) continue;
            String version = this.getAttribute(plugin, "version");
            if (version == null) {
                version = "0.0.0";
            }
            PluginRef ref = new PluginRef("plugin");
            ref.setId(id);
            ref.setVersion(version);
            this.extraPlugins.add(ref);
        }
    }

    private String getAttribute(PlexusConfiguration dom, String attrName) {
        String attr = dom.getAttribute(attrName);
        if (attr == null) {
            return null;
        }
        if ((attr = attr.trim()).length() == 0) {
            return null;
        }
        return attr;
    }
}

