/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.extras.docbundle;

import java.io.File;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.exec.OS;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.DefaultConsumer;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.tycho.core.osgitools.BundleReader;
import org.eclipse.tycho.core.osgitools.OsgiManifest;
import org.eclipse.tycho.extras.docbundle.DocletArtifactsResolver;
import org.eclipse.tycho.extras.docbundle.JavadocOptions;
import org.eclipse.tycho.extras.docbundle.PackageNameMatcher;

public class JavadocRunner {
    private File output;
    private ToolchainManager toolchainManager;
    private MavenSession session;
    private Set<File> sourceFolders = Collections.emptySet();
    private Set<File> manifestFiles = Collections.emptySet();
    private Log log;
    private JavadocOptions options;
    private File buildDirectory;
    private BundleReader bundleReader;
    private Collection<String> classPath = Collections.emptyList();
    private String lineSeparator = System.lineSeparator();
    private DocletArtifactsResolver docletArtifactsResolver;
    private PackageNameMatcher includeMatcher;
    private PackageNameMatcher excludeMatcher;

    public void setBundleReader(BundleReader bundleReader) {
        this.bundleReader = bundleReader;
    }

    public void setBuildDirectory(File buildDirectory) {
        this.buildDirectory = buildDirectory;
    }

    public void setOptions(JavadocOptions options) {
        this.options = options;
        if (this.options == null) {
            this.options = new JavadocOptions();
        }
    }

    public void setLog(Log log) {
        this.log = log;
    }

    public void setSession(MavenSession session) {
        this.session = session;
    }

    public void setOutput(File output) {
        this.output = output;
    }

    public void run() throws Exception {
        this.output.mkdirs();
        this.buildDirectory.mkdirs();
        File optionsFile = new File(this.buildDirectory, "javadoc.options.txt");
        Commandline cli = this.createCommandLine(optionsFile.getAbsolutePath());
        try (PrintStream ps = new PrintStream(optionsFile);){
            ps.print(this.createOptionsFileContent());
            ps.close();
            this.log.info((CharSequence)("Calling: " + cli));
            int rc = CommandLineUtils.executeCommandLine((Commandline)cli, (StreamConsumer)new DefaultConsumer(), (StreamConsumer)new DefaultConsumer());
            if (rc != 0) {
                if (!this.options.isIgnoreError()) {
                    throw new MojoExecutionException("Failed to execute javadoc - rc = " + rc);
                }
                this.log.info((CharSequence)("execution failed with rc = " + rc));
            }
        }
    }

    Commandline createCommandLine(String optionsFileAbsolutePath) {
        Commandline cli = new Commandline();
        cli.setExecutable(this.getExecutable());
        cli.setWorkingDirectory(this.output);
        cli.createArg().setValue("@" + optionsFileAbsolutePath);
        this.addJvmArgs(cli);
        return cli;
    }

    String createOptionsFileContent() throws Exception {
        if (this.options != null) {
            if (!this.options.getIncludes().isEmpty()) {
                this.includeMatcher = PackageNameMatcher.compile(this.options.getIncludes());
                this.log.info((CharSequence)("Including packages matching " + this.includeMatcher));
            }
            if (!this.options.getExcludes().isEmpty()) {
                this.excludeMatcher = PackageNameMatcher.compile(this.options.getExcludes());
                this.log.info((CharSequence)("Excluding packages matching " + this.excludeMatcher));
            }
        }
        StringBuilder sb = new StringBuilder();
        this.addSourcePaths(sb);
        this.addClassPath(sb);
        this.addDoclet(sb);
        this.addDocletPaths(sb);
        this.addEncoding(sb);
        this.addArguments(sb);
        int count = this.addPackages(sb);
        if (count <= 0) {
            this.log.warn((CharSequence)"No packages found");
        }
        return sb.toString();
    }

    private void addEncoding(StringBuilder sb) {
        if (this.options.getEncoding() != null) {
            sb.append("-encoding ").append(this.options.getEncoding()).append(this.lineSeparator);
        }
    }

    private void addDoclet(StringBuilder sb) {
        if (this.options.getDoclet() == null) {
            return;
        }
        sb.append("-doclet ").append(this.options.getDoclet()).append(this.lineSeparator);
    }

    private void addDocletPaths(StringBuilder sb) throws MojoExecutionException {
        Set<String> resolvedArtifactJars = this.docletArtifactsResolver.resolveArtifacts(this.options.getDocletArtifacts());
        this.addPathArgument(sb, "-docletpath", resolvedArtifactJars);
    }

    private void addClassPath(StringBuilder sb) {
        this.addPathArgument(sb, "-classpath", this.classPath);
    }

    private void addArguments(StringBuilder sb) {
        for (String argument : this.options.getAdditionalArguments()) {
            sb.append(argument).append(this.lineSeparator);
        }
    }

    private void addJvmArgs(Commandline cli) {
        for (String arg : this.options.getJvmOptions()) {
            cli.createArg().setValue("-J" + arg);
        }
    }

    private int addPackages(StringBuilder sb) throws Exception {
        int count = 0;
        for (File manifestFile : this.manifestFiles) {
            if (!manifestFile.canRead()) {
                this.log.debug((CharSequence)("No readable manifest: " + manifestFile));
                continue;
            }
            OsgiManifest bundle = this.bundleReader.loadManifest(manifestFile);
            count += this.addPackages(sb, bundle.getManifestElements("Export-Package"));
        }
        return count;
    }

    private int addPackages(StringBuilder sb, ManifestElement[] manifestElements) {
        if (manifestElements == null) {
            return 0;
        }
        for (ManifestElement ele : manifestElements) {
            boolean exclude;
            String pkg = ele.getValue();
            boolean include = this.includeMatcher != null ? this.includeMatcher.matches(pkg) : true;
            boolean bl = exclude = this.excludeMatcher != null ? this.excludeMatcher.matches(pkg) : false;
            if (!include || exclude) continue;
            sb.append(pkg).append(this.lineSeparator);
        }
        return manifestElements.length;
    }

    private void addPath(StringBuilder sb, Collection<?> path) {
        boolean first = true;
        for (Object ele : path) {
            if (ele == null) continue;
            String pathEle = ele.toString().replace('\\', '/');
            if (!first) {
                sb.append(File.pathSeparator);
            } else {
                first = false;
            }
            sb.append(pathEle);
        }
    }

    private void addSourcePaths(StringBuilder sb) {
        this.addPathArgument(sb, "-sourcepath", this.sourceFolders);
    }

    private void addPathArgument(StringBuilder sb, String arg, Collection<?> path) {
        if (path.isEmpty()) {
            return;
        }
        sb.append(arg);
        sb.append(" '");
        this.addPath(sb, path);
        sb.append("'" + this.lineSeparator);
    }

    protected String getExecutable() {
        this.log.debug((CharSequence)"Find javadoc executable");
        if (this.options.getExecutable() != null) {
            this.log.debug((CharSequence)("Using specified javadoc: " + this.options.getExecutable()));
            return this.options.getExecutable();
        }
        this.log.debug((CharSequence)("Toolchain manager: " + this.toolchainManager));
        if (this.toolchainManager != null) {
            Toolchain tc = this.toolchainManager.getToolchainFromBuildContext("jdk", this.session);
            this.log.debug((CharSequence)("Toolchain: " + tc));
            if (tc != null) {
                String exe = tc.findTool("javadoc");
                this.log.debug((CharSequence)("Toolchain Tool: " + exe));
                if (exe != null) {
                    return exe;
                }
            }
        }
        String javaHome = System.getProperty("java.home");
        String javadocFromJavaHome = OS.isFamilyMac() ? javaHome + File.separator + "bin" + File.separator + "javadoc" : javaHome + File.separator + ".." + File.separator + "bin" + File.separator + "javadoc";
        if (OS.isFamilyWindows()) {
            javadocFromJavaHome = javadocFromJavaHome + ".exe";
        }
        this.log.debug((CharSequence)("Testing javadoc from java.home = " + javadocFromJavaHome));
        if (new File(javadocFromJavaHome).canExecute()) {
            return javadocFromJavaHome;
        }
        this.log.debug((CharSequence)"Using path fallback");
        return "javadoc";
    }

    public void setToolchainManager(ToolchainManager toolchainManager) {
        this.toolchainManager = toolchainManager;
    }

    public void setSourceFolders(Set<File> sourceFolders) {
        this.sourceFolders = sourceFolders;
    }

    public void setClassPath(Collection<String> classPath) {
        this.classPath = classPath;
    }

    public void setManifestFiles(Set<File> manifestFiles) {
        this.manifestFiles = manifestFiles;
    }

    public void setDocletArtifactsResolver(DocletArtifactsResolver docletArtifactsResolver) {
        this.docletArtifactsResolver = docletArtifactsResolver;
    }
}

