/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.launch.internal;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.inject.Provider;
import org.eclipse.sisu.BeanScanning;
import org.eclipse.sisu.inject.DefaultBeanLocator;
import org.eclipse.sisu.inject.Logs;
import org.eclipse.sisu.launch.Main;
import org.eclipse.sisu.launch.SisuExtensions;
import org.eclipse.sisu.space.BundleClassSpace;
import org.eclipse.sisu.space.ClassSpace;
import org.eclipse.sisu.space.SpaceModule;
import org.eclipse.sisu.wire.ParameterKeys;
import org.eclipse.sisu.wire.WireModule;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.BundleTracker;
import org.osgi.util.tracker.BundleTrackerCustomizer;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public final class SisuActivator
implements BundleActivator,
BundleTrackerCustomizer,
ServiceTrackerCustomizer {
    static final String CONTAINER_SYMBOLIC_NAME = "org.eclipse.sisu.inject";
    static final String BUNDLE_INJECTOR_CLASS_NAME = BundleInjector.class.getName();
    private static Reference<DefaultBeanLocator> LOCATOR_REF;
    private DefaultBeanLocator locator;
    private BundleContext sisuBundleContext;
    private ServiceTracker serviceTracker;
    private BundleTracker bundleTracker;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(BundleContext context) {
        Class<SisuActivator> clazz = SisuActivator.class;
        synchronized (SisuActivator.class) {
            if (LOCATOR_REF != null) {
                this.locator = LOCATOR_REF.get();
            }
            if (this.locator == null) {
                this.locator = new DefaultBeanLocator();
                LOCATOR_REF = new WeakReference<DefaultBeanLocator>(this.locator);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.sisuBundleContext = context;
            this.serviceTracker = new ServiceTracker(context, BUNDLE_INJECTOR_CLASS_NAME, (ServiceTrackerCustomizer)this);
            this.serviceTracker.open(true);
            this.bundleTracker = new BundleTracker(context, 32, (BundleTrackerCustomizer)this);
            this.bundleTracker.open();
            return;
        }
    }

    public void stop(BundleContext context) {
        this.bundleTracker.close();
        this.serviceTracker.close();
        this.locator.clear();
    }

    public Object addingBundle(Bundle bundle, BundleEvent event) {
        if (CONTAINER_SYMBOLIC_NAME.equals(bundle.getSymbolicName())) {
            return null;
        }
        if (SisuActivator.needsScanning(bundle) && SisuActivator.getBundleInjectorService(bundle) == null) {
            try {
                new BundleInjector(this.locator, bundle);
            }
            catch (RuntimeException e) {
                Logs.warn((String)"Problem starting: {}", (Object)bundle, (Object)e);
            }
        }
        return null;
    }

    public void modifiedBundle(Bundle bundle, BundleEvent event, Object object) {
    }

    public void removedBundle(Bundle bundle, BundleEvent event, Object object) {
    }

    public Object addingService(ServiceReference reference) {
        Object injector;
        Object service = this.sisuBundleContext.getService(reference);
        if (service instanceof Provider && (injector = ((Provider)service).get()) instanceof Injector) {
            this.locator.add((Injector)injector, 0);
            return injector;
        }
        return null;
    }

    public void modifiedService(ServiceReference reference, Object injector) {
    }

    public void removedService(ServiceReference reference, Object injector) {
        if (injector instanceof Injector) {
            this.locator.remove((Injector)injector);
        }
        this.sisuBundleContext.ungetService(reference);
    }

    private static boolean needsScanning(Bundle bundle) {
        Dictionary headers = bundle.getHeaders();
        String host = (String)headers.get("Fragment-Host");
        if (host != null) {
            return false;
        }
        String imports = (String)headers.get("Import-Package");
        if (imports == null) {
            return false;
        }
        return imports.contains("javax.inject") || imports.contains("com.google.inject");
    }

    private static ServiceReference getBundleInjectorService(Bundle bundle) {
        ServiceReference[] serviceReferences = bundle.getRegisteredServices();
        if (serviceReferences != null) {
            ServiceReference[] serviceReferenceArray = serviceReferences;
            int n = serviceReferences.length;
            int n2 = 0;
            while (n2 < n) {
                ServiceReference ref = serviceReferenceArray[n2];
                String[] stringArray = (String[])ref.getProperty("objectClass");
                int n3 = stringArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    String name = stringArray[n4];
                    if (BUNDLE_INJECTOR_CLASS_NAME.equals(name)) {
                        return ref;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class BundleInjector
    implements Provider<Injector> {
        private static final String[] API = new String[]{BUNDLE_INJECTOR_CLASS_NAME};
        private final Injector injector;

        BundleInjector(final DefaultBeanLocator locator, final Bundle bundle) {
            final BundleContext extendedBundleContext = bundle.getBundleContext();
            final BundleProperties properties = new BundleProperties(extendedBundleContext);
            BundleClassSpace space = new BundleClassSpace(bundle);
            BeanScanning scanning = Main.selectScanning((Map)properties);
            final SisuExtensions extensions = SisuExtensions.local((ClassSpace)space);
            this.injector = Guice.createInjector((Module[])new Module[]{new WireModule(new Module[]{new AbstractModule(){

                protected void configure() {
                    this.bind(DefaultBeanLocator.class).toInstance((Object)locator);
                    this.bind(BundleContext.class).toInstance((Object)extendedBundleContext);
                    this.bind(ParameterKeys.PROPERTIES).toInstance((Object)properties);
                    extensions.install(this.binder(), Bundle.class, (Object)bundle);
                }
            }, new SpaceModule((ClassSpace)space, scanning).with((SpaceModule.Strategy)extensions)}).with((WireModule.Strategy)extensions)});
            Hashtable<String, String> metadata = new Hashtable<String, String>();
            ((Dictionary)metadata).put("service.pid", SisuActivator.CONTAINER_SYMBOLIC_NAME);
            extendedBundleContext.registerService(API, (Object)this, metadata);
        }

        public Injector get() {
            return this.injector;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class BundleProperties
    extends AbstractMap<Object, Object> {
        private final transient BundleContext context;

        BundleProperties(BundleContext context) {
            this.context = context;
        }

        @Override
        public Object get(Object key) {
            return this.context.getProperty(String.valueOf(key));
        }

        @Override
        public boolean containsKey(Object key) {
            return this.get(key) != null;
        }

        @Override
        public Set<Map.Entry<Object, Object>> entrySet() {
            return Collections.emptySet();
        }

        @Override
        public int size() {
            return 0;
        }
    }
}

