/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.session;

import java.util.concurrent.TimeUnit;
import javax.security.auth.Subject;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.config.CONFIG;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.CompositeObject;
import org.eclipse.scout.rt.platform.util.collection.ConcurrentExpiringMap;
import org.eclipse.scout.rt.security.IAccessControlService;
import org.eclipse.scout.rt.server.IServerSession;
import org.eclipse.scout.rt.server.ServerConfigProperties;
import org.eclipse.scout.rt.server.context.ServerRunContext;
import org.eclipse.scout.rt.server.context.ServerRunContexts;
import org.eclipse.scout.rt.server.session.ServerSessionProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerSessionProviderWithCache
extends ServerSessionProvider {
    private static final Logger LOG = LoggerFactory.getLogger(ServerSessionProviderWithCache.class);
    private final ConcurrentExpiringMap<CompositeObject, IServerSession> m_cache = this.createSessionCache((Long)CONFIG.getPropertyValue(ServerConfigProperties.ServerSessionCacheExpirationProperty.class));

    @Override
    public <SESSION extends IServerSession> SESSION provide(ServerRunContext serverRunContext) {
        return this.provide(null, serverRunContext);
    }

    @Override
    public <SESSION extends IServerSession> SESSION provide(String sessionId, ServerRunContext serverRunContext) {
        CompositeObject sessionCacheKey = this.newSessionCacheKey(sessionId, serverRunContext.getSubject());
        if (sessionCacheKey == null) {
            LOG.warn("Cannot identify cached server session because the cache key is undefined  [sessionId={}, subject={}]", (Object)sessionId, (Object)serverRunContext.getSubject());
            return super.provide(sessionId, serverRunContext);
        }
        IServerSession serverSession = (IServerSession)this.m_cache.get((Object)sessionCacheKey);
        if (serverSession != null) {
            return (SESSION)serverSession;
        }
        serverSession = super.provide(sessionId, serverRunContext);
        IServerSession cachedServerSession = (IServerSession)this.m_cache.putIfAbsent((Object)sessionCacheKey, (Object)serverSession);
        if (cachedServerSession != null) {
            LOG.trace("Found a cached server session, using that one instead - stopping the replaced one.");
            serverSession.stop();
            serverSession = cachedServerSession;
        }
        return (SESSION)serverSession;
    }

    public void remove(IServerSession session) {
        this.remove(((IServerSession)Assertions.assertNotNull((Object)session)).getId());
    }

    public void remove(String sessionId) {
        Assertions.assertNotNull((Object)sessionId);
        this.m_cache.values().removeIf(sess -> sess.getId().equals(sessionId));
    }

    protected ConcurrentExpiringMap<CompositeObject, IServerSession> createSessionCache(long ttl) {
        return new ConcurrentExpiringMap<CompositeObject, IServerSession>(ttl, TimeUnit.MILLISECONDS, 1000){

            protected void execEntryEvicted(CompositeObject key, IServerSession session) {
                if (session == null || !session.isActive() || session.isStopping()) {
                    return;
                }
                if (ServerSessionProvider.currentSession() == session) {
                    session.stop();
                } else {
                    ServerRunContexts.copyCurrent(true).withSession(session).run(() -> ((IServerSession)session).stop());
                }
            }
        };
    }

    protected CompositeObject newSessionCacheKey(String sessionId, Subject subject) {
        if (sessionId != null) {
            return new CompositeObject(new Object[]{sessionId});
        }
        if (subject != null) {
            return new CompositeObject(new Object[]{((IAccessControlService)BEANS.get(IAccessControlService.class)).getUserId(subject)});
        }
        return null;
    }
}

