/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.session;

import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.transaction.TransactionScope;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.server.IServerSession;
import org.eclipse.scout.rt.server.context.ServerRunContext;
import org.eclipse.scout.rt.server.context.ServerRunContexts;
import org.eclipse.scout.rt.shared.session.Sessions;

@ApplicationScoped
public class ServerSessionProvider {
    public <SESSION extends IServerSession> SESSION provide(ServerRunContext serverRunContext) {
        return this.provide(null, serverRunContext);
    }

    public <SESSION extends IServerSession> SESSION provide(String sessionId, ServerRunContext serverRunContext) {
        return (SESSION)((IServerSession)Assertions.assertNotNull(this.opt(sessionId, serverRunContext), (String)"No session class implementing {} could be found on the classpath.", (Object[])new Object[]{IServerSession.class.getName()}));
    }

    public <SESSION extends IServerSession> SESSION opt(String sessionId, ServerRunContext serverRunContext) {
        String sid = sessionId != null ? sessionId : Sessions.randomSessionId();
        return (SESSION)((IServerSession)serverRunContext.copy().withTransactionScope(TransactionScope.REQUIRES_NEW).call(() -> {
            IServerSession session = (IServerSession)BEANS.opt(IServerSession.class);
            if (session == null) {
                return null;
            }
            return (IServerSession)ServerRunContexts.copyCurrent().withSession(session).withTransactionScope(TransactionScope.MANDATORY).call(() -> {
                this.beforeStartSession(session, sid);
                session.start(sid);
                this.afterStartSession(session);
                return session;
            });
        }));
    }

    protected void beforeStartSession(IServerSession serverSession, String sessionId) {
    }

    protected void afterStartSession(IServerSession serverSession) {
    }

    public static IServerSession currentSession() {
        return (IServerSession)Sessions.currentSession(IServerSession.class);
    }

    public static <SESSION extends IServerSession> SESSION currentSession(Class<SESSION> type) {
        return (SESSION)((IServerSession)Sessions.currentSession(type));
    }
}

