/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.session;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.scout.rt.platform.util.FinalValue;
import org.eclipse.scout.rt.server.IServerSession;
import org.eclipse.scout.rt.server.context.ServerRunContexts;
import org.eclipse.scout.rt.server.session.IServerSessionLifecycleHandler;
import org.eclipse.scout.rt.server.session.ServerSessionProvider;

public class ServerSessionEntry {
    private final Set<String> m_httpSessionSet = new HashSet<String>(1);
    private final IServerSessionLifecycleHandler m_sessionLifecycleHandler;
    private final FinalValue<IServerSession> m_serverSession = new FinalValue();

    protected ServerSessionEntry(IServerSessionLifecycleHandler sessionLifecycleHandler) {
        this.m_sessionLifecycleHandler = sessionLifecycleHandler;
    }

    protected IServerSession getOrCreateScoutSession() {
        return (IServerSession)this.m_serverSession.setIfAbsentAndGet(this.m_sessionLifecycleHandler::create);
    }

    public IServerSession getScoutSession() {
        return (IServerSession)this.m_serverSession.get();
    }

    protected IServerSessionLifecycleHandler getServerSessionLifecycleHandler() {
        return this.m_sessionLifecycleHandler;
    }

    protected boolean addHttpSessionId(String httpSessionId) {
        return this.m_httpSessionSet.add(httpSessionId);
    }

    protected boolean removeHttpSessionId(String httpSessionId) {
        return this.m_httpSessionSet.remove(httpSessionId);
    }

    public int httpSessionCount() {
        return this.m_httpSessionSet.size();
    }

    protected void destroy() {
        IServerSession session = this.getScoutSession();
        if (session == null) {
            return;
        }
        if (ServerSessionProvider.currentSession() == session) {
            this.m_sessionLifecycleHandler.destroy(session);
        } else {
            ServerRunContexts.copyCurrent(true).withSession(session).run(() -> this.m_sessionLifecycleHandler.destroy(session));
        }
    }
}

