/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.session;

import jakarta.servlet.http.HttpSession;
import java.util.Map;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.util.concurrent.GroupedSynchronizer;
import org.eclipse.scout.rt.server.IServerSession;
import org.eclipse.scout.rt.server.session.IServerSessionLifecycleHandler;
import org.eclipse.scout.rt.server.session.ScoutSessionBindingListener;
import org.eclipse.scout.rt.server.session.ServerSessionEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class ServerSessionCache {
    private static final Logger LOG = LoggerFactory.getLogger(ServerSessionCache.class);
    public static final String SERVER_SESSION_KEY = IServerSession.class.getName();
    public static final String UNBIND_LISTENER_KEY = ScoutSessionBindingListener.class.getName();
    private final GroupedSynchronizer<String, ServerSessionEntry> m_lockBySessionId = new GroupedSynchronizer(true);

    public IServerSession getOrCreate(IServerSessionLifecycleHandler sessionLifecycleHandler, HttpSession httpSession) {
        Object scoutSession = httpSession.getAttribute(SERVER_SESSION_KEY);
        if (scoutSession instanceof IServerSession) {
            return (IServerSession)scoutSession;
        }
        return (IServerSession)this.m_lockBySessionId.applyInGroupLock((Object)sessionLifecycleHandler.getId(), sessionContext -> this.getOrCreate((ServerSessionEntry)sessionContext, httpSession), sessionId -> new ServerSessionEntry(sessionLifecycleHandler));
    }

    protected IServerSession getOrCreate(ServerSessionEntry sessionContext, HttpSession httpSession) {
        IServerSession session = sessionContext.getOrCreateScoutSession();
        if (session == null) {
            LOG.warn("No class implementing {} could be found. If no server session class is available, using a {} is not necessary. Please fix your configuration to skip the {} creation.", new Object[]{IServerSession.class.getName(), ServerSessionCache.class.getName(), IServerSession.class.getName()});
            return null;
        }
        boolean newlyAdded = sessionContext.addHttpSessionId(httpSession.getId());
        if (newlyAdded) {
            httpSession.setAttribute(SERVER_SESSION_KEY, (Object)session);
            httpSession.setAttribute(UNBIND_LISTENER_KEY, (Object)new ScoutSessionBindingListener(session.getId()));
            if (LOG.isDebugEnabled()) {
                LOG.debug("Scout ServerSession Session added to HttpSession [scoutSessionId={}, httpSessionId={}]", (Object)session.getId(), (Object)httpSession.getId());
            }
        }
        return session;
    }

    public void removeHttpSession(String scoutSessionId, String httpSessionId) {
        ServerSessionEntry removedEntry = (ServerSessionEntry)this.m_lockBySessionId.remove((Object)scoutSessionId, entry -> this.removeEntry((ServerSessionEntry)entry, httpSessionId));
        if (removedEntry != null) {
            LOG.debug("Removed Scout server session from cache [scoutSessionId={}, httpSessionId={}].", (Object)scoutSessionId, (Object)httpSessionId);
            removedEntry.destroy();
        }
    }

    protected boolean removeEntry(ServerSessionEntry scoutSessionContext, String httpSessionId) {
        scoutSessionContext.removeHttpSessionId(httpSessionId);
        return scoutSessionContext.httpSessionCount() < 1;
    }

    public Map<String, ServerSessionEntry> cacheMap() {
        return this.m_lockBySessionId.toMap();
    }

    public int numRootLocks() {
        return this.m_lockBySessionId.numRootLocks();
    }

    public int numLockedRootLocks() {
        return this.m_lockBySessionId.numLockedRootLocks();
    }

    public int size() {
        return this.m_lockBySessionId.size();
    }
}

