/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.lookup;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.scout.rt.platform.util.MatrixUtility;
import org.eclipse.scout.rt.shared.services.lookup.ILookupCall;
import org.eclipse.scout.rt.shared.services.lookup.ILookupRow;
import org.eclipse.scout.rt.shared.services.lookup.ILookupService;
import org.eclipse.scout.rt.shared.services.lookup.LookupRow;

public abstract class AbstractLookupService<LOOKUP_ROW_KEY_TYPE>
implements ILookupService<LOOKUP_ROW_KEY_TYPE> {
    public static void sortData(Object[][] data, int ... sortColumns) {
        MatrixUtility.sort((Object[][])data, (int[])sortColumns);
    }

    public static <KEY_TYPE> List<ILookupRow<KEY_TYPE>> createLookupRowArray(Object[][] data, ILookupCall<KEY_TYPE> call, Class<?> keyClass) {
        int maxColumnIndex = data.length > 0 ? data[0].length - 1 : 0;
        return AbstractLookupService.createLookupRowArray(data, maxColumnIndex, call, keyClass);
    }

    public static <KEY_TYPE> List<ILookupRow<KEY_TYPE>> createLookupRowArray(Object[][] data, int maxColumnIndex, ILookupCall<KEY_TYPE> call, Class<?> keyClass) {
        ArrayList<ILookupRow<KEY_TYPE>> list = new ArrayList<ILookupRow<KEY_TYPE>>(data.length);
        Boolean active = call.getActive().getBooleanValue();
        Object[][] objectArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            Object[] aData = objectArray[n2];
            LookupRow row = new LookupRow(aData, maxColumnIndex, keyClass);
            if (active == null || active.booleanValue() == row.isActive()) {
                list.add((ILookupRow<KEY_TYPE>)row);
            }
            ++n2;
        }
        return list;
    }
}

