/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.security;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.Objects;
import java.util.Set;
import org.eclipse.scout.rt.api.data.security.PermissionUpdateMessageDo;
import org.eclipse.scout.rt.api.uinotification.UiNotificationPutOptions;
import org.eclipse.scout.rt.api.uinotification.UiNotificationRegistry;
import org.eclipse.scout.rt.dataobject.IDoEntity;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.CreateImmediately;
import org.eclipse.scout.rt.platform.cache.ICacheEntryFilter;
import org.eclipse.scout.rt.platform.cache.ICacheInvalidationListener;
import org.eclipse.scout.rt.platform.cache.KeyCacheEntryFilter;
import org.eclipse.scout.rt.platform.transaction.AbstractTransactionMember;
import org.eclipse.scout.rt.platform.transaction.ITransaction;
import org.eclipse.scout.rt.security.IAccessControlService;
import org.eclipse.scout.rt.security.IPermissionCollection;
import org.eclipse.scout.rt.server.context.ServerRunContexts;

@ApplicationScoped
@CreateImmediately
public class PermissionsInvalidationNotificationListener
implements ICacheInvalidationListener<Object, IPermissionCollection> {
    @PostConstruct
    protected void init() {
        BEANS.optional(IAccessControlService.class).ifPresent(svc -> svc.addInvalidationListener((ICacheInvalidationListener)this));
    }

    @PreDestroy
    protected void destroy() {
        BEANS.optional(IAccessControlService.class).ifPresent(svc -> svc.removeInvalidationListener((ICacheInvalidationListener)this));
    }

    public void invalidated(ICacheEntryFilter<Object, IPermissionCollection> filter, boolean propagate) {
        if (filter == null) {
            return;
        }
        ITransaction transaction = (ITransaction)ITransaction.CURRENT.get();
        if (transaction == null) {
            return;
        }
        transaction.registerMemberIfAbsentAndNotCancelled("permissionsUiNotification.transactionMemberId", id -> this.createTransactionMember(filter));
    }

    protected PermissionsUiNotificationTransactionMember createTransactionMember(ICacheEntryFilter<Object, IPermissionCollection> filter) {
        return new PermissionsUiNotificationTransactionMember(filter);
    }

    public static class PermissionsUiNotificationTransactionMember
    extends AbstractTransactionMember {
        public static final String TOPIC = "permissionsUpdate";
        public static final String TRANSACTION_MEMBER_ID = "permissionsUiNotification.transactionMemberId";
        private final ICacheEntryFilter<Object, IPermissionCollection> m_filter;

        public PermissionsUiNotificationTransactionMember(ICacheEntryFilter<Object, IPermissionCollection> filter) {
            super(TRANSACTION_MEMBER_ID);
            this.m_filter = filter;
        }

        public boolean needsCommit() {
            return true;
        }

        public void commitPhase2() {
            UiNotificationRegistry uiNotificationRegistry = (UiNotificationRegistry)BEANS.get(UiNotificationRegistry.class);
            long reloadDelayWindow = uiNotificationRegistry.computeNotificationHandlerDelayWindow(TOPIC);
            PermissionUpdateMessageDo updateDo = ((PermissionUpdateMessageDo)BEANS.get(PermissionUpdateMessageDo.class)).withReloadDelayWindow(Long.valueOf(reloadDelayWindow));
            if (this.m_filter instanceof KeyCacheEntryFilter) {
                IAccessControlService accessControlService = (IAccessControlService)BEANS.get(IAccessControlService.class);
                Set cacheKeys = ((KeyCacheEntryFilter)this.m_filter).getKeys();
                ServerRunContexts.copyCurrent().run(() -> cacheKeys.stream().map(arg_0 -> ((IAccessControlService)accessControlService).getUserIdForCacheKey(arg_0)).filter(Objects::nonNull).forEach(userId -> uiNotificationRegistry.put(TOPIC, userId, (IDoEntity)updateDo, UiNotificationPutOptions.noTransaction().withPublishOverCluster(Boolean.valueOf(false)))));
            } else {
                uiNotificationRegistry.put(TOPIC, (IDoEntity)updateDo, UiNotificationPutOptions.noTransaction().withPublishOverCluster(Boolean.valueOf(false)));
            }
        }
    }
}

