/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.pwd;

import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.security.PasswordPolicy;
import org.eclipse.scout.rt.shared.services.common.pwd.IPasswordManagementService;

public abstract class AbstractPasswordManagementService
implements IPasswordManagementService {
    private PasswordPolicy m_passwordPolicy;

    public AbstractPasswordManagementService() {
        this.setPasswordPolicy((PasswordPolicy)BEANS.get(PasswordPolicy.class));
    }

    public void changePassword(String userId, char[] oldPassword, char[] newPassword) {
        this.checkAccess(userId, oldPassword);
        this.resetPassword(userId, newPassword);
    }

    public void resetPassword(String userId, char[] newPassword) {
        this.getPasswordPolicy().check(this.getUsernameFor(userId), newPassword, this.getHistoryIndexFor(userId, newPassword));
        this.resetPasswordInternal(userId, newPassword);
    }

    public String getPasswordPolicyText() {
        return this.getPasswordPolicy().getText();
    }

    protected PasswordPolicy getPasswordPolicy() {
        return this.m_passwordPolicy;
    }

    protected void setPasswordPolicy(PasswordPolicy p) {
        this.m_passwordPolicy = p;
    }

    protected abstract void checkAccess(String var1, char[] var2);

    protected abstract int getHistoryIndexFor(String var1, char[] var2);

    protected abstract void resetPasswordInternal(String var1, char[] var2);
}

