/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.code;

import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.scout.rt.api.data.code.CodeTypeDo;
import org.eclipse.scout.rt.api.data.code.CodeTypeUpdateMessageDo;
import org.eclipse.scout.rt.api.uinotification.UiNotificationPutOptions;
import org.eclipse.scout.rt.api.uinotification.UiNotificationRegistry;
import org.eclipse.scout.rt.dataobject.IDoEntity;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.CreateImmediately;
import org.eclipse.scout.rt.platform.cache.ICacheEntryFilter;
import org.eclipse.scout.rt.platform.cache.ICacheInvalidationListener;
import org.eclipse.scout.rt.platform.transaction.AbstractTransactionMember;
import org.eclipse.scout.rt.platform.transaction.ITransaction;
import org.eclipse.scout.rt.platform.transaction.TransactionScope;
import org.eclipse.scout.rt.security.IAccessControlService;
import org.eclipse.scout.rt.server.context.ServerRunContexts;
import org.eclipse.scout.rt.shared.services.common.code.ApiExposedCodeTypeDoProvider;
import org.eclipse.scout.rt.shared.services.common.code.CodeService;
import org.eclipse.scout.rt.shared.services.common.code.CodeTypeCacheKey;
import org.eclipse.scout.rt.shared.services.common.code.CodeTypeCacheUtility;
import org.eclipse.scout.rt.shared.services.common.code.ICodeType;

@ApplicationScoped
@CreateImmediately
public class CodeTypeInvalidationNotificationListener
implements ICacheInvalidationListener<CodeTypeCacheKey, ICodeType<?, ?>> {
    @PostConstruct
    protected void init() {
        ((CodeService)BEANS.get(CodeService.class)).addInvalidationListener((ICacheInvalidationListener)this);
    }

    @PreDestroy
    protected void destroy() {
        ((CodeService)BEANS.get(CodeService.class)).removeInvalidationListener((ICacheInvalidationListener)this);
    }

    public void invalidated(ICacheEntryFilter<CodeTypeCacheKey, ICodeType<?, ?>> filter, boolean propagate) {
        if (filter == null) {
            return;
        }
        ITransaction transaction = (ITransaction)ITransaction.CURRENT.get();
        if (transaction == null) {
            return;
        }
        CodeTypeUiNotificationTransactionMember member = (CodeTypeUiNotificationTransactionMember)transaction.registerMemberIfAbsentAndNotCancelled("codeTypeUiNotification.transactionMemberId", this::createTransactionMember);
        if (member == null) {
            return;
        }
        member.registerCodeTypeInvalidate(filter);
    }

    protected CodeTypeUiNotificationTransactionMember createTransactionMember(String memberId) {
        return new CodeTypeUiNotificationTransactionMember();
    }

    public static class CodeTypeUiNotificationTransactionMember
    extends AbstractTransactionMember {
        public static final String TRANSACTION_MEMBER_ID = "codeTypeUiNotification.transactionMemberId";
        public static final String TOPIC = "codeTypeUpdate";
        private final List<ICacheEntryFilter<CodeTypeCacheKey, ICodeType<?, ?>>> m_invalidations = new ArrayList();

        public CodeTypeUiNotificationTransactionMember() {
            super(TRANSACTION_MEMBER_ID);
        }

        public void registerCodeTypeInvalidate(ICacheEntryFilter<CodeTypeCacheKey, ICodeType<?, ?>> filter) {
            this.m_invalidations.add(filter);
        }

        public void rollback() {
            this.m_invalidations.clear();
        }

        public void cancel() {
            this.m_invalidations.clear();
        }

        public boolean needsCommit() {
            return !this.m_invalidations.isEmpty();
        }

        public void commitPhase2() {
            ServerRunContexts.copyCurrent().withTransactionScope(TransactionScope.REQUIRES_NEW).run(this::notifyInvalidatedCodeTypes);
            this.m_invalidations.clear();
        }

        public void notifyInvalidatedCodeTypes() {
            CodeTypeCacheUtility codeTypeCacheUtility = (CodeTypeCacheUtility)BEANS.get(CodeTypeCacheUtility.class);
            List<CodeTypeDo> updatedAndExposedCodeTypes = ((ApiExposedCodeTypeDoProvider)BEANS.get(ApiExposedCodeTypeDoProvider.class)).getExposedCodeTypes().stream().filter(codeType -> this.needsNotify(codeTypeCacheUtility.createCacheKey(codeType.getClass()), (ICodeType<?, ?>)codeType)).map(ICodeType::toDo).filter(Objects::nonNull).collect(Collectors.toList());
            this.notifyExposedCodeTypeUpdate(updatedAndExposedCodeTypes);
        }

        public boolean needsNotify(CodeTypeCacheKey cacheKey, ICodeType<?, ?> codeType) {
            return this.m_invalidations.stream().anyMatch(filter -> filter.accept((Object)cacheKey, (Object)codeType));
        }

        public void notifyExposedCodeTypeUpdate(List<CodeTypeDo> codeTypes) {
            if (codeTypes.isEmpty()) {
                return;
            }
            UiNotificationRegistry uiNotificationRegistry = (UiNotificationRegistry)BEANS.get(UiNotificationRegistry.class);
            String currentUserId = this.getUserId();
            CodeTypeUpdateMessageDo messageWithNewCodeTypes = ((CodeTypeUpdateMessageDo)BEANS.get(CodeTypeUpdateMessageDo.class)).withCodeTypes(codeTypes);
            uiNotificationRegistry.put(TOPIC, currentUserId, (IDoEntity)messageWithNewCodeTypes, UiNotificationPutOptions.noTransaction().withPublishOverCluster(Boolean.valueOf(false)));
            Set idsToUpdate = codeTypes.stream().map(CodeTypeDo::getId).collect(Collectors.toSet());
            long reloadDelayWindow = uiNotificationRegistry.computeNotificationHandlerDelayWindow(TOPIC);
            CodeTypeUpdateMessageDo messageWithCodeTypeIdsToUpdate = ((CodeTypeUpdateMessageDo)BEANS.get(CodeTypeUpdateMessageDo.class)).withCodeTypeIds(idsToUpdate).withReloadDelayWindow(Long.valueOf(reloadDelayWindow));
            uiNotificationRegistry.putExcept(TOPIC, Collections.singleton(currentUserId), (IDoEntity)messageWithCodeTypeIdsToUpdate, UiNotificationPutOptions.noTransaction().withPublishOverCluster(Boolean.valueOf(false)));
        }

        protected String getUserId() {
            return ((IAccessControlService)BEANS.get(IAccessControlService.class)).getUserIdOfCurrentSubject();
        }
    }
}

