/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.clustersync;

import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.security.auth.Subject;
import org.eclipse.scout.rt.dataobject.id.NodeId;
import org.eclipse.scout.rt.mom.api.ClusterMom;
import org.eclipse.scout.rt.mom.api.IMessage;
import org.eclipse.scout.rt.mom.api.IMessageListener;
import org.eclipse.scout.rt.mom.api.ISubscription;
import org.eclipse.scout.rt.mom.api.MOM;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.IPlatform;
import org.eclipse.scout.rt.platform.IPlatformListener;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.PlatformEvent;
import org.eclipse.scout.rt.platform.config.CONFIG;
import org.eclipse.scout.rt.platform.security.SimplePrincipal;
import org.eclipse.scout.rt.platform.transaction.AbstractTransactionMember;
import org.eclipse.scout.rt.platform.transaction.ITransaction;
import org.eclipse.scout.rt.platform.transaction.ITransactionMember;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.server.IServerSession;
import org.eclipse.scout.rt.server.ServerConfigProperties;
import org.eclipse.scout.rt.server.context.ServerRunContext;
import org.eclipse.scout.rt.server.context.ServerRunContexts;
import org.eclipse.scout.rt.server.mom.IClusterMomDestinations;
import org.eclipse.scout.rt.server.services.common.clustersync.ClusterNodeStatusInfo;
import org.eclipse.scout.rt.server.services.common.clustersync.ClusterNotificationMessageCoalescer;
import org.eclipse.scout.rt.server.services.common.clustersync.IClusterNodeStatusInfo;
import org.eclipse.scout.rt.server.services.common.clustersync.IClusterNotificationMessage;
import org.eclipse.scout.rt.server.services.common.clustersync.IClusterNotificationProperties;
import org.eclipse.scout.rt.server.services.common.clustersync.IClusterSynchronizationService;
import org.eclipse.scout.rt.server.services.common.clustersync.internal.ClusterNotificationMessage;
import org.eclipse.scout.rt.server.services.common.clustersync.internal.ClusterNotificationProperties;
import org.eclipse.scout.rt.server.session.ServerSessionProviderWithCache;
import org.eclipse.scout.rt.shared.ISession;
import org.eclipse.scout.rt.shared.notification.NotificationHandlerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterSynchronizationService
implements IClusterSynchronizationService,
IMessageListener<IClusterNotificationMessage> {
    private static final Logger LOG = LoggerFactory.getLogger(ClusterSynchronizationService.class);
    private static final String TRANSACTION_MEMBER_ID = ClusterSynchronizationService.class.getName();
    private final ClusterNodeStatusInfo m_statusInfo = new ClusterNodeStatusInfo();
    private final ConcurrentMap<Class<? extends Serializable>, ClusterNodeStatusInfo> m_messageStatusMap = new ConcurrentHashMap<Class<? extends Serializable>, ClusterNodeStatusInfo>();
    private final Subject m_subject;
    private volatile ISubscription m_subscription;
    private final Object m_subscriptionLock = new Object();
    private final NodeId m_nodeId = NodeId.current();

    public ClusterSynchronizationService() {
        this.m_subject = new Subject();
        this.m_subject.getPrincipals().add((Principal)new SimplePrincipal((String)CONFIG.getPropertyValue(ServerConfigProperties.ClusterSyncUserProperty.class)));
        this.m_subject.setReadOnly();
    }

    @Override
    public IClusterNodeStatusInfo getStatusInfo() {
        return this.m_statusInfo.getStatus();
    }

    protected ClusterNodeStatusInfo getStatusInfoInternal() {
        return this.m_statusInfo;
    }

    protected ClusterNodeStatusInfo getStatusInfoInternal(Class<? extends Serializable> messageType) {
        this.m_messageStatusMap.putIfAbsent(messageType, new ClusterNodeStatusInfo());
        return (ClusterNodeStatusInfo)this.m_messageStatusMap.get(messageType);
    }

    public NodeId getNodeId() {
        return this.m_nodeId;
    }

    @Override
    public boolean isEnabled() {
        return this.m_subscription != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean enable() {
        if (this.isEnabled()) {
            return true;
        }
        if (((ClusterMom)BEANS.get(ClusterMom.class)).isNullTransport()) {
            LOG.info("Cluster synchronization is not enabled.");
            return false;
        }
        Object object = this.m_subscriptionLock;
        synchronized (object) {
            block9: {
                if (!this.isEnabled()) break block9;
                return true;
            }
            try {
                this.m_subscription = MOM.subscribe(ClusterMom.class, IClusterMomDestinations.CLUSTER_NOTIFICATION_TOPIC, (IMessageListener)this, null);
            }
            catch (RuntimeException e) {
                LOG.error("Failed to subscribe to {}", IClusterMomDestinations.CLUSTER_NOTIFICATION_TOPIC, (Object)e);
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean disable() {
        ISubscription subscription;
        if (!this.isEnabled()) {
            return true;
        }
        Object object = this.m_subscriptionLock;
        synchronized (object) {
            subscription = this.m_subscription;
            this.m_subscription = null;
        }
        try {
            if (subscription != null) {
                subscription.dispose();
            }
        }
        catch (RuntimeException e) {
            LOG.error("Failed to unsubscribe from {}", IClusterMomDestinations.CLUSTER_NOTIFICATION_TOPIC, (Object)e);
        }
        return true;
    }

    @Override
    public void publishTransactional(Serializable notification) {
        if (this.isEnabled()) {
            LOG.trace("Adding {} to transaction", (Object)notification);
            this.getTransaction().addMessage(new ClusterNotificationMessage(notification, this.getNotificationProperties()));
        }
    }

    @Override
    public void publish(Serializable notification) {
        this.publishAll(CollectionUtility.arrayList((Object)notification));
    }

    private void publishAll(Collection<Serializable> notifications) {
        if (this.isEnabled()) {
            ArrayList<IClusterNotificationMessage> internalMessages = new ArrayList<IClusterNotificationMessage>();
            for (Serializable n : notifications) {
                internalMessages.add(new ClusterNotificationMessage(n, this.getNotificationProperties()));
            }
            this.publishInternal(internalMessages);
        }
    }

    private void publishInternal(List<IClusterNotificationMessage> messages) {
        for (IClusterNotificationMessage message : messages) {
            LOG.trace("Publishing {}", (Object)message);
            MOM.publish(ClusterMom.class, IClusterMomDestinations.CLUSTER_NOTIFICATION_TOPIC, (Object)message);
        }
        for (IClusterNotificationMessage im : messages) {
            this.getStatusInfoInternal().updateSentStatus(im);
            this.getStatusInfoInternal(im.getNotification().getClass()).updateReceiveStatus(im);
        }
    }

    @Override
    public IClusterNotificationProperties getNotificationProperties() {
        ISession curentSession = (ISession)ISession.CURRENT.get();
        String userid = curentSession != null ? curentSession.getUserId() : "";
        return new ClusterNotificationProperties(this.m_nodeId, userid);
    }

    public void onMessage(IMessage<IClusterNotificationMessage> message) {
        IClusterNotificationMessage notificationMessage = (IClusterNotificationMessage)message.getTransferObject();
        if (this.isEnabled()) {
            NodeId originNode = notificationMessage.getProperties().getOriginNode();
            if (this.m_nodeId.equals((Object)originNode)) {
                LOG.trace("Ignoring {} (reason: own node)", (Object)notificationMessage);
                return;
            }
            LOG.trace("Handling {}", (Object)notificationMessage);
            this.getStatusInfoInternal().updateReceiveStatus(notificationMessage);
            this.getStatusInfoInternal(notificationMessage.getNotification().getClass()).updateReceiveStatus(notificationMessage);
            ServerRunContext serverRunContext = ServerRunContexts.empty();
            serverRunContext.withSubject(this.m_subject);
            serverRunContext.withSession((IServerSession)((ServerSessionProviderWithCache)BEANS.get(ServerSessionProviderWithCache.class)).provide(serverRunContext.copy()));
            serverRunContext.run(() -> {
                NotificationHandlerRegistry reg = (NotificationHandlerRegistry)BEANS.get(NotificationHandlerRegistry.class);
                reg.notifyNotificationHandlers(notificationMessage.getNotification());
            });
        }
    }

    protected ClusterSynchTransactionMember getTransaction() {
        ITransaction tx = (ITransaction)Assertions.assertNotNull((Object)((ITransaction)ITransaction.CURRENT.get()), (String)"Transaction required", (Object[])new Object[0]);
        ClusterSynchTransactionMember m = (ClusterSynchTransactionMember)tx.getMember(TRANSACTION_MEMBER_ID);
        if (m == null) {
            m = new ClusterSynchTransactionMember(TRANSACTION_MEMBER_ID);
            tx.registerMember((ITransactionMember)m);
        }
        return m;
    }

    @Override
    public IClusterNodeStatusInfo getStatusInfo(Class<? extends Serializable> messageType) {
        return this.getStatusInfoInternal(messageType).getStatus();
    }

    private class ClusterSynchTransactionMember
    extends AbstractTransactionMember {
        private List<IClusterNotificationMessage> m_messageQueue;

        public ClusterSynchTransactionMember(String transactionId) {
            super(transactionId);
            this.m_messageQueue = new LinkedList<IClusterNotificationMessage>();
        }

        public synchronized void addMessage(IClusterNotificationMessage m) {
            this.m_messageQueue.add(m);
            this.m_messageQueue = ((ClusterNotificationMessageCoalescer)BEANS.get(ClusterNotificationMessageCoalescer.class)).coalesce(this.m_messageQueue);
        }

        public synchronized boolean needsCommit() {
            return !this.m_messageQueue.isEmpty();
        }

        public synchronized void commitPhase2() {
            ClusterSynchronizationService.this.publishInternal(this.m_messageQueue);
        }

        public synchronized void rollback() {
            this.m_messageQueue.clear();
        }
    }

    @Order(value=5700.0)
    public static class PlatformListener
    implements IPlatformListener {
        public void stateChanged(PlatformEvent event) {
            if (event.getState() == IPlatform.State.PlatformStopping) {
                for (ClusterSynchronizationService service : BEANS.all(ClusterSynchronizationService.class)) {
                    service.disable();
                }
            }
        }
    }
}

