/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.bookmark;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Permission;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.exception.ProcessingException;
import org.eclipse.scout.rt.platform.serialization.SerializationUtility;
import org.eclipse.scout.rt.security.ACCESS;
import org.eclipse.scout.rt.server.services.common.bookmark.AbstractBookmarkStorageService;
import org.eclipse.scout.rt.server.session.ServerSessionProvider;
import org.eclipse.scout.rt.shared.security.PublishUserBookmarkPermission;
import org.eclipse.scout.rt.shared.security.UpdateUserBookmarkPermission;
import org.eclipse.scout.rt.shared.services.common.bookmark.BookmarkFolder;
import org.eclipse.scout.rt.shared.services.common.file.IRemoteFileService;
import org.eclipse.scout.rt.shared.services.common.file.RemoteFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemBookmarkStorageService
extends AbstractBookmarkStorageService {
    private static final Logger LOG = LoggerFactory.getLogger(FileSystemBookmarkStorageService.class);
    public static final String GLOBAL_FILE_NAME = "all_users";

    @Override
    public void publishBookmarkData(BookmarkFolder publishFolder, Map<String, Object> targetGroup) {
        Object userId;
        if (!ACCESS.check((Permission)new PublishUserBookmarkPermission())) {
            throw new ProcessingException("Function denied", new Object[]{new SecurityException("Function denied")});
        }
        HashSet<Object> set = new HashSet<Object>();
        Collection userIdList = (Collection)targetGroup.get("userIdList");
        if (userIdList != null) {
            set.addAll(userIdList);
        }
        if ((userId = targetGroup.get("userId")) != null) {
            set.add(userId);
        }
        for (Object e : set) {
            this.publishBookmarkDataToUser(publishFolder, e);
        }
    }

    @Override
    protected Object getCurrentUserId() {
        return ServerSessionProvider.currentSession().getUserId();
    }

    @Override
    protected BookmarkFolder readUserFolder(Object userId) {
        return this.readBookmarkFolder(String.valueOf(userId) + ".ser");
    }

    @Override
    protected BookmarkFolder readGlobalFolder() {
        return this.readBookmarkFolder("all_users.ser");
    }

    @Override
    protected void writeUserFolder(BookmarkFolder folder, Object userId) {
        this.writeBookmarkFolder(folder, String.valueOf(userId) + ".ser", (Permission)new UpdateUserBookmarkPermission());
    }

    @Override
    protected void writeGlobalFolder(BookmarkFolder folder) {
        this.writeBookmarkFolder(folder, "all_users.ser", (Permission)new UpdateUserBookmarkPermission());
    }

    private BookmarkFolder readBookmarkFolder(String filename) {
        RemoteFile spec = new RemoteFile("bookmarks", filename, 0L);
        RemoteFile f = ((IRemoteFileService)BEANS.get(IRemoteFileService.class)).getRemoteFile(spec);
        if (f.exists()) {
            try {
                byte[] bytes = f.extractData();
                return (BookmarkFolder)SerializationUtility.createObjectSerializer().deserialize(bytes, BookmarkFolder.class);
            }
            catch (Exception t) {
                LOG.error("Could not deserialize bookmark folder", (Throwable)t);
            }
        }
        return null;
    }

    private void writeBookmarkFolder(BookmarkFolder folder, String filename, Permission permission) {
        try {
            if (ACCESS.check((Permission)permission)) {
                byte[] bytes = SerializationUtility.createObjectSerializer().serialize((Object)folder);
                RemoteFile spec = new RemoteFile("bookmarks", filename, 0L);
                spec.readData((InputStream)new ByteArrayInputStream(bytes));
                ((IRemoteFileService)BEANS.get(IRemoteFileService.class)).putRemoteFile(spec);
            }
        }
        catch (IOException e) {
            throw new ProcessingException("", new Object[]{e});
        }
    }
}

