/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.services.common.bookmark;

import java.io.IOException;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigOperation;
import org.eclipse.scout.rt.platform.exception.ProcessingException;
import org.eclipse.scout.rt.platform.serialization.SerializationUtility;
import org.eclipse.scout.rt.server.services.common.bookmark.AbstractBookmarkStorageService;
import org.eclipse.scout.rt.shared.services.common.bookmark.BookmarkFolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSqlBookmarkStorageService
extends AbstractBookmarkStorageService {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractSqlBookmarkStorageService.class);

    @ConfigOperation
    @Order(value=10.0)
    protected Object[][] execSelectUserBookmarkFolder(Object userId) {
        return new Object[0][];
    }

    @ConfigOperation
    @Order(value=11.0)
    protected Object[][] execSelectGlobalBookmarkFolder() {
        return new Object[0][];
    }

    @ConfigOperation
    @Order(value=20.0)
    protected void execStoreUserBookmarkFolder(Object userId, long id, byte[] folderData) {
    }

    @ConfigOperation
    @Order(value=21.0)
    protected void execStoreGlobalBookmarkFolder(long id, byte[] folderData) {
    }

    @ConfigOperation
    @Order(value=30.0)
    protected BookmarkFolder execResolveBookmarkFolder(long id, Object binaryData) {
        try {
            byte[] bytesResolved = (byte[])binaryData;
            return (BookmarkFolder)SerializationUtility.createObjectSerializer().deserialize(bytesResolved, BookmarkFolder.class);
        }
        catch (Exception e) {
            throw new ProcessingException("loading object" + id, new Object[]{e});
        }
    }

    @Override
    protected BookmarkFolder readUserFolder(Object userId) {
        Object[][] data;
        Object[][] objectArray = data = this.execSelectUserBookmarkFolder(userId);
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            Object[] row = objectArray[n2];
            long id = ((Number)row[0]).longValue();
            try {
                BookmarkFolder folder = this.execResolveBookmarkFolder(id, row[1]);
                if (folder != null) {
                    folder.setId(id);
                    return folder;
                }
            }
            catch (RuntimeException p) {
                LOG.warn("invalid bookmark folder binary data for id={}: {}", (Object)id, (Object)p);
            }
            ++n2;
        }
        return null;
    }

    @Override
    protected BookmarkFolder readGlobalFolder() {
        Object[][] data;
        Object[][] objectArray = data = this.execSelectGlobalBookmarkFolder();
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            Object[] row = objectArray[n2];
            long id = ((Number)row[0]).longValue();
            try {
                BookmarkFolder folder = this.execResolveBookmarkFolder(id, row[1]);
                if (folder != null) {
                    folder.setId(id);
                    return folder;
                }
            }
            catch (RuntimeException p) {
                LOG.warn("invalid bookmark folder binary data for id={}: {}", (Object)id, (Object)p);
            }
            ++n2;
        }
        return null;
    }

    @Override
    protected void writeUserFolder(BookmarkFolder folder, Object userId) {
        try {
            byte[] data = SerializationUtility.createObjectSerializer().serialize((Object)folder);
            this.execStoreUserBookmarkFolder(userId, folder.getId(), data);
        }
        catch (IOException e) {
            throw new ProcessingException("storing user bookmarks", new Object[]{e});
        }
    }

    @Override
    protected void writeGlobalFolder(BookmarkFolder folder) {
        try {
            byte[] data = SerializationUtility.createObjectSerializer().serialize((Object)folder);
            this.execStoreGlobalBookmarkFolder(folder.getId(), data);
        }
        catch (IOException e) {
            throw new ProcessingException("storing global bookmarks", new Object[]{e});
        }
    }
}

