/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.notification;

import jakarta.annotation.PostConstruct;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.CreateImmediately;
import org.eclipse.scout.rt.platform.TypeParameterBeanRegistry;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.server.notification.ICoalescer;

@ApplicationScoped
@CreateImmediately
public class NotificationCoalescer {
    private final TypeParameterBeanRegistry<ICoalescer> m_registry = new TypeParameterBeanRegistry(ICoalescer.class);

    @PostConstruct
    protected void buildCoalescerLinking() {
        this.m_registry.registerBeans(BEANS.all(ICoalescer.class));
    }

    public <T extends Serializable> List<T> coalesce(List<T> notificationsIn) {
        if (notificationsIn.size() < 2) {
            return notificationsIn;
        }
        int i = 0;
        List<T> res = notificationsIn;
        while (i < res.size()) {
            List coalescers = this.m_registry.getBeans(((Serializable)res.get(i)).getClass());
            ICoalescer c = (ICoalescer)CollectionUtility.firstElement((List)coalescers);
            if (c != null) {
                int j = this.getCoalesceCount(c, res.subList(i, res.size()));
                res = this.coalesce(i, i + j, c, res);
            }
            ++i;
        }
        return res;
    }

    private <T extends Serializable> List<T> coalesce(int from, int to, ICoalescer<T> c, List<T> notifications) {
        ArrayList<T> res = new ArrayList<T>();
        res.addAll(notifications.subList(0, from));
        res.addAll(c.coalesce(notifications.subList(from, to)));
        res.addAll(notifications.subList(to, notifications.size()));
        return res;
    }

    private int getCoalesceCount(ICoalescer<?> c, List<? extends Serializable> notifications) {
        int i = 0;
        while (i < notifications.size() && this.isApplicable(c, notifications, i)) {
            ++i;
        }
        return i;
    }

    private boolean isApplicable(ICoalescer<?> c, List<? extends Serializable> notifications, int i) {
        Serializable n = notifications.get(i);
        return this.m_registry.getBeans(n.getClass()).contains(c);
    }
}

