/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.mom;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.eclipse.scout.rt.mom.api.AbstractMomTransport;
import org.eclipse.scout.rt.mom.api.IMomImplementor;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.server.commons.healthcheck.AbstractHealthChecker;
import org.eclipse.scout.rt.server.commons.healthcheck.HealthCheckCategoryId;
import org.eclipse.scout.rt.server.commons.healthcheck.IHealthChecker;

public abstract class AbstractMomHealthChecker
extends AbstractHealthChecker {
    private final boolean m_isActive = this.initializeActive();

    protected abstract Class<? extends AbstractMomTransport> getConfiguredMomClass();

    protected abstract boolean execCheckHealth(IMomImplementor var1) throws Exception;

    protected long getConfiguredTimeoutMillis() {
        return TimeUnit.SECONDS.toMillis(30L);
    }

    protected boolean initializeActive() {
        AbstractMomTransport momTransport = (AbstractMomTransport)BEANS.opt(this.getConfiguredMomClass());
        return momTransport != null && !momTransport.isNullTransport();
    }

    public boolean isActive() {
        return this.m_isActive;
    }

    protected boolean execCheckHealth(HealthCheckCategoryId category) throws Exception {
        IMomImplementor implementor = ((AbstractMomTransport)BEANS.get(this.getConfiguredMomClass())).getImplementor();
        if (implementor == null) {
            return false;
        }
        return this.execCheckHealth(implementor);
    }

    public boolean acceptCategory(HealthCheckCategoryId category) {
        return Objects.equals(category, IHealthChecker.Readiness.ID);
    }
}

