/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.context;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import javax.security.auth.Subject;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.server.context.HttpServerRunContextProducer;
import org.eclipse.scout.rt.server.context.ServerRunContext;
import org.eclipse.scout.rt.server.context.ServerRunContextProducer;

public class ServerRunContextFilter
implements Filter {
    private ServerRunContextProducer m_sessionContextProducer;
    private HttpServerRunContextProducer m_httpServerRunContextProducer;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.m_sessionContextProducer = this.createSessionRunContextProducer();
        this.m_httpServerRunContextProducer = this.createHttpServerRunContextProducer();
    }

    protected HttpServerRunContextProducer createHttpServerRunContextProducer() {
        return ((HttpServerRunContextProducer)BEANS.get(HttpServerRunContextProducer.class)).withSessionSupport(false);
    }

    protected HttpServerRunContextProducer getHttpServerRunContextProducer() {
        return this.m_httpServerRunContextProducer;
    }

    protected ServerRunContextProducer createSessionRunContextProducer() {
        return (ServerRunContextProducer)((Object)BEANS.get(ServerRunContextProducer.class));
    }

    protected ServerRunContextProducer getSessionContextProducer() {
        return this.m_sessionContextProducer;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        this.lookupRunContext(req, resp).run(() -> chain.doFilter(request, response));
    }

    protected ServerRunContext lookupRunContext(HttpServletRequest req, HttpServletResponse resp) {
        ServerRunContext sessionContext = this.getSessionContextProducer().produce(Subject.current());
        return this.getHttpServerRunContextProducer().produce(req, resp, null, sessionContext);
    }

    public void destroy() {
        this.m_sessionContextProducer = null;
        this.m_httpServerRunContextProducer = null;
    }
}

