/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.clientnotification;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.scout.rt.dataobject.id.NodeId;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.transaction.AbstractTransactionMember;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.server.clientnotification.ClientNotificationCoalescer;
import org.eclipse.scout.rt.server.clientnotification.ClientNotificationCollector;
import org.eclipse.scout.rt.server.clientnotification.ClientNotificationRegistry;
import org.eclipse.scout.rt.server.clientnotification.IClientNodeId;
import org.eclipse.scout.rt.shared.clientnotification.ClientNotificationMessage;

public class ClientNotificationTransactionMember
extends AbstractTransactionMember {
    public static final String TRANSACTION_MEMBER_ID = "clientNotification.transactionMemberId";
    private final List<ClientNotificationMessage> m_notifications = new ArrayList<ClientNotificationMessage>();
    private final ClientNotificationCoalescer m_coalescer;
    private final ClientNotificationRegistry m_notificationRegistry;
    private List<ClientNotificationMessage> m_notificationsToPublish;

    public ClientNotificationTransactionMember(ClientNotificationRegistry reg) {
        super(TRANSACTION_MEMBER_ID);
        this.m_notificationRegistry = reg;
        this.m_coalescer = (ClientNotificationCoalescer)BEANS.get(ClientNotificationCoalescer.class);
    }

    public void rollback() {
        this.m_notifications.clear();
    }

    public void cancel() {
        this.m_notifications.clear();
    }

    public boolean needsCommit() {
        return !this.m_notifications.isEmpty();
    }

    public void addNotification(ClientNotificationMessage message) {
        this.m_notifications.add(message);
    }

    public void commitPhase2() {
        List<ClientNotificationMessage> coalescedNotifications = this.m_coalescer.coalesce(new ArrayList<ClientNotificationMessage>(this.m_notifications));
        this.publish(coalescedNotifications);
        this.m_notifications.clear();
    }

    private void publish(List<ClientNotificationMessage> notifications) {
        if (this.tryPiggyBack(notifications)) {
            this.m_notificationRegistry.publish(notifications, (NodeId)Assertions.assertNotNull((Object)IClientNodeId.CURRENT.get(), (String)"Missing 'client node id' on current calling context", (Object[])new Object[0]));
        } else {
            this.m_notificationsToPublish = notifications;
        }
    }

    private boolean tryPiggyBack(List<ClientNotificationMessage> notifications) {
        ClientNotificationCollector collector = ClientNotificationCollector.CURRENT.get();
        if (IClientNodeId.CURRENT.get() != null && collector != null) {
            return collector.addAll(notifications);
        }
        return false;
    }

    public void release() {
        if (this.m_notificationsToPublish != null) {
            this.m_notificationRegistry.publish(this.m_notificationsToPublish);
            this.m_notificationsToPublish = null;
        }
    }
}

