/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.clientnotification;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.eclipse.scout.rt.dataobject.id.NodeId;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.config.CONFIG;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.server.clientnotification.ClientNotificationProperties;
import org.eclipse.scout.rt.server.clientnotification.ClientNotificationRegistry;
import org.eclipse.scout.rt.shared.clientnotification.ClientNotificationMessage;
import org.eclipse.scout.rt.shared.clientnotification.IClientNotificationService;

public class ClientNotificationService
implements IClientNotificationService {
    private final int m_blockingTimeout = (Integer)Assertions.assertNotNull((Object)((Integer)CONFIG.getPropertyValue(ClientNotificationProperties.MaxNotificationBlockingTimeOut.class)));
    private final int m_maxNotifications = (Integer)Assertions.assertNotNull((Object)((Integer)CONFIG.getPropertyValue(ClientNotificationProperties.MaxNotificationMessages.class)));

    public void registerNode(NodeId nodeId) {
        ((ClientNotificationRegistry)BEANS.get(ClientNotificationRegistry.class)).registerNode(nodeId);
    }

    public void unregisterNode(NodeId nodeId) {
        ((ClientNotificationRegistry)BEANS.get(ClientNotificationRegistry.class)).unregisterNode(nodeId);
    }

    public List<ClientNotificationMessage> getNotifications(NodeId nodeId) {
        return ((ClientNotificationRegistry)BEANS.get(ClientNotificationRegistry.class)).consume(nodeId, this.m_maxNotifications, this.m_blockingTimeout, TimeUnit.MILLISECONDS);
    }
}

