/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.cache;

import java.util.Collection;
import java.util.Map;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.cache.ICache;
import org.eclipse.scout.rt.platform.cache.ICacheEntryFilter;
import org.eclipse.scout.rt.platform.cache.ICacheRegistryService;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.shared.cache.IRemoteCacheService;

public class RemoteCacheService
implements IRemoteCacheService {
    public <K, V> V get(String cacheId, K key) {
        ICache<K, V> cache = this.getCache(cacheId);
        if (cache != null) {
            return (V)cache.get(key);
        }
        return null;
    }

    public <K, V> Map<K, V> getAll(String cacheId, Collection<? extends K> keys) {
        ICache<K, V> cache = this.getCache(cacheId);
        if (cache != null) {
            return cache.getAll(keys);
        }
        return CollectionUtility.emptyHashMap();
    }

    public <K, V> void invalidate(String cacheId, ICacheEntryFilter<K, V> filter, boolean propagate) {
        ICache<K, V> cache = this.getCache(cacheId);
        if (cache != null) {
            cache.invalidate(filter, propagate);
        }
    }

    protected <K, V> ICache<K, V> getCache(String cacheId) {
        return ((ICacheRegistryService)BEANS.get(ICacheRegistryService.class)).get(cacheId);
    }
}

