/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.cache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.scout.rt.platform.cache.ICacheEntryFilter;
import org.eclipse.scout.rt.platform.cache.InvalidateCacheNotification;
import org.eclipse.scout.rt.server.notification.ICoalescer;

public class InvalidateCacheNotificationCoalescer
implements ICoalescer<InvalidateCacheNotification> {
    @Override
    public List<InvalidateCacheNotification> coalesce(List<InvalidateCacheNotification> notifications) {
        ArrayList<InvalidateCacheNotification> result = new ArrayList<InvalidateCacheNotification>();
        if (notifications.isEmpty()) {
            return result;
        }
        HashMap filterMap = new HashMap();
        for (InvalidateCacheNotification invalidateCacheNotification : notifications) {
            ArrayList list = (ArrayList)filterMap.get(invalidateCacheNotification.getCacheId());
            if (list == null) {
                list = new ArrayList();
                list.add(invalidateCacheNotification.getFilter());
            } else {
                this.coalesceFilters(list, invalidateCacheNotification.getFilter());
            }
            filterMap.put(invalidateCacheNotification.getCacheId(), list);
        }
        for (Map.Entry entry : filterMap.entrySet()) {
            for (ICacheEntryFilter filter : (List)entry.getValue()) {
                result.add(new InvalidateCacheNotification((String)entry.getKey(), filter));
            }
        }
        return result;
    }

    protected void coalesceFilters(List<ICacheEntryFilter<?, ?>> list, ICacheEntryFilter filter) {
        Iterator<ICacheEntryFilter<?, ?>> iterator = list.iterator();
        while (iterator.hasNext()) {
            ICacheEntryFilter<?, ?> otherFilter = iterator.next();
            ICacheEntryFilter newFilter = filter.coalesce(otherFilter);
            ICacheEntryFilter iCacheEntryFilter = newFilter = newFilter != null ? newFilter : otherFilter.coalesce(filter);
            if (newFilter == null) continue;
            iterator.remove();
            iterator = list.iterator();
            filter = newFilter;
        }
        list.add(filter);
    }
}

