/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.util.ConnectionErrorDetector;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.server.commons.servlet.HttpServletControl;
import org.eclipse.scout.rt.server.commons.servlet.cache.HttpCacheControl;
import org.eclipse.scout.rt.server.commons.servlet.cache.HttpCacheKey;
import org.eclipse.scout.rt.server.commons.servlet.cache.HttpCacheObject;
import org.eclipse.scout.rt.shared.services.common.file.IRemoteFileService;
import org.eclipse.scout.rt.shared.services.common.file.RemoteFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteFileServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(RemoteFileServlet.class);
    private String m_folder;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.m_folder = this.parseFolderParam(config.getInitParameter("folder"));
    }

    protected String parseFolderParam(String value) {
        if (!StringUtility.hasText((CharSequence)value)) {
            return "";
        }
        value = value.replaceAll("\\\\", "/");
        while (value.startsWith("/")) {
            value = value.substring(1);
        }
        while (value.endsWith("/")) {
            value = value.substring(0, value.lastIndexOf(47));
        }
        return "/" + value;
    }

    protected String getFolder() {
        return this.m_folder;
    }

    protected void setFolder(String folder) {
        this.m_folder = folder;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.handleHttpRequest(req, res);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.handleHttpRequest(req, res);
    }

    protected void handleHttpRequest(HttpServletRequest req, HttpServletResponse res) {
        ((HttpServletControl)BEANS.get(HttpServletControl.class)).doDefaults((HttpServlet)this, req, res);
        String pathInfo = this.extractPathInfo(req);
        List<String> fileList = Arrays.asList(pathInfo);
        if (StringUtility.isNullOrEmpty((CharSequence)pathInfo) || pathInfo.replaceAll("\\\\", "/").endsWith("/")) {
            String prefix = "/";
            if (pathInfo != null && pathInfo.replaceAll("\\\\", "/").endsWith("/")) {
                prefix = pathInfo.replaceAll("\\\\", "/");
            }
            fileList = Arrays.asList(prefix + "index.html", prefix + "index.htm", prefix + "default.html", prefix + "default.htm", prefix + "index.jsp", prefix + "index.php");
        }
        try {
            List<String> fileListParam = fileList;
            Iterator<String> pathIter = fileListParam.iterator();
            boolean success = false;
            while (!success && pathIter.hasNext()) {
                success = this.writeResource(req, res, pathIter.next());
            }
            if (!success) {
                res.sendError(404, pathInfo);
            }
        }
        catch (Exception ex) {
            if (((ConnectionErrorDetector)BEANS.get(ConnectionErrorDetector.class)).isConnectionError((Throwable)ex)) {
                LOG.debug("Connection error detected: exception class={}, message={}.", new Object[]{ex.getClass().getSimpleName(), ex.getMessage(), ex});
            }
            LOG.warn("Failed to get remotefile {}.", (Object)pathInfo, (Object)ex);
            res.setStatus(500);
        }
    }

    protected String extractPathInfo(HttpServletRequest request) {
        return request.getPathInfo();
    }

    protected Class<? extends IRemoteFileService> getConfiguredRemoteFileServiceClass() {
        return IRemoteFileService.class;
    }

    private boolean writeResource(HttpServletRequest req, HttpServletResponse resp, String resourcePath) throws IOException {
        RemoteFile spec;
        IRemoteFileService rfs = (IRemoteFileService)BEANS.get(this.getConfiguredRemoteFileServiceClass());
        RemoteFile remoteFile = rfs.getRemoteFile(spec = new RemoteFile(resourcePath == null ? null : StringUtility.join((String)"", (Object[])new Object[]{this.m_folder, resourcePath}), -1L));
        if (!remoteFile.exists()) {
            return false;
        }
        HttpCacheObject obj = new HttpCacheObject(new HttpCacheKey(resourcePath), remoteFile.toBinaryResource());
        if (((HttpCacheControl)BEANS.get(HttpCacheControl.class)).checkAndSetCacheHeaders(req, resp, obj)) {
            return true;
        }
        rfs.streamRemoteFile(remoteFile, (OutputStream)resp.getOutputStream());
        return true;
    }
}

