/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.Predicate;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.annotations.ConfigOperation;
import org.eclipse.scout.rt.platform.job.IFuture;
import org.eclipse.scout.rt.platform.job.Jobs;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.TypeCastUtility;
import org.eclipse.scout.rt.platform.util.event.FastListenerList;
import org.eclipse.scout.rt.platform.util.event.IFastListenerList;
import org.eclipse.scout.rt.security.IAccessControlService;
import org.eclipse.scout.rt.server.IServerSession;
import org.eclipse.scout.rt.server.clientnotification.ClientNotificationRegistry;
import org.eclipse.scout.rt.server.clientnotification.IClientNodeId;
import org.eclipse.scout.rt.server.context.RunMonitorCancelRegistry;
import org.eclipse.scout.rt.server.extension.IServerSessionExtension;
import org.eclipse.scout.rt.server.extension.ServerSessionChains;
import org.eclipse.scout.rt.server.session.ServerSessionProviderWithCache;
import org.eclipse.scout.rt.shared.ISession;
import org.eclipse.scout.rt.shared.extension.AbstractSerializableExtension;
import org.eclipse.scout.rt.shared.extension.IExtensibleObject;
import org.eclipse.scout.rt.shared.extension.IExtension;
import org.eclipse.scout.rt.shared.extension.ObjectExtensions;
import org.eclipse.scout.rt.shared.job.filter.future.SessionFutureFilter;
import org.eclipse.scout.rt.shared.services.common.context.SharedContextChangedNotification;
import org.eclipse.scout.rt.shared.services.common.context.SharedVariableMap;
import org.eclipse.scout.rt.shared.services.common.security.ILogoutService;
import org.eclipse.scout.rt.shared.session.IGlobalSessionListener;
import org.eclipse.scout.rt.shared.session.ISessionListener;
import org.eclipse.scout.rt.shared.session.SessionData;
import org.eclipse.scout.rt.shared.session.SessionEvent;
import org.eclipse.scout.rt.shared.session.SessionMetricsHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServerSession
implements IServerSession,
Serializable,
IExtensibleObject {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractServerSession.class);
    protected static final String SESSION_TYPE = "server";
    protected final transient SessionMetricsHelper m_sessionMetrics = (SessionMetricsHelper)BEANS.get(SessionMetricsHelper.class);
    private final transient FastListenerList<ISessionListener> m_eventListeners = new FastListenerList();
    private String m_id;
    private volatile boolean m_initialized;
    private volatile boolean m_active;
    private volatile boolean m_stopping;
    private final SessionData m_sessionData = new SessionData();
    private final SharedVariableMap m_sharedVariableMap = new SharedVariableMap();
    private final ObjectExtensions<AbstractServerSession, IServerSessionExtension<? extends AbstractServerSession>> m_objectExtensions = new ObjectExtensions((Object)this, true);

    public AbstractServerSession(boolean autoInitConfig) {
        this.m_sessionMetrics.sessionCreated(SESSION_TYPE);
        if (autoInitConfig) {
            this.interceptInitConfig();
        }
    }

    public Map<String, Object> getSharedVariableMap() {
        return CollectionUtility.copyMap((Map)this.m_sharedVariableMap);
    }

    protected <T> T getSharedContextVariable(String name, Class<T> type) {
        Object o = this.m_sharedVariableMap.get((Object)name);
        return (T)TypeCastUtility.castValue((Object)o, type);
    }

    protected <T> void setSharedContextVariable(String name, Class<T> type, T value) {
        Object typedValue = TypeCastUtility.castValue(value, type);
        this.m_sharedVariableMap.put(name, typedValue);
    }

    private void assignUserId() {
        String userId = ((IAccessControlService)BEANS.get(IAccessControlService.class)).getUserIdOfCurrentSubject();
        this.setUserIdInternal(userId);
    }

    public boolean isActive() {
        return this.m_active;
    }

    public boolean isStopping() {
        return this.m_stopping;
    }

    public final String getUserId() {
        return this.getSharedContextVariable("userId", String.class);
    }

    private void setUserIdInternal(String newValue) {
        this.setSharedContextVariable("userId", String.class, newValue);
    }

    public Object getData(String key) {
        return this.m_sessionData.get(key);
    }

    public void setData(String key, Object value) {
        this.m_sessionData.set(key, value);
    }

    public Object computeDataIfAbsent(String key, Callable<?> producer) {
        return this.m_sessionData.computeIfAbsent(key, producer);
    }

    protected final void interceptInitConfig() {
        this.m_objectExtensions.initConfig(this.createLocalExtension(), this::initConfig);
    }

    protected void initConfig() {
        if (this.m_initialized) {
            return;
        }
        this.m_sharedVariableMap.addPropertyChangeListener(e -> {
            if (IClientNodeId.CURRENT.get() != null) {
                String sessionId = this.getId();
                if (sessionId != null) {
                    SharedContextChangedNotification notification = new SharedContextChangedNotification(CollectionUtility.copyMap((Map)this.m_sharedVariableMap));
                    ((ClientNotificationRegistry)BEANS.get(ClientNotificationRegistry.class)).putTransactionalForSession(sessionId, (Serializable)notification);
                } else {
                    LOG.warn("No sessionId set");
                }
            }
        });
        this.m_initialized = true;
    }

    public final List<? extends IServerSessionExtension<? extends AbstractServerSession>> getAllExtensions() {
        return this.m_objectExtensions.getAllExtensions();
    }

    protected IServerSessionExtension<? extends AbstractServerSession> createLocalExtension() {
        return new LocalServerSessionExtension<AbstractServerSession>(this);
    }

    public <T extends IExtension<?>> T getExtension(Class<T> c) {
        return (T)this.m_objectExtensions.getExtension(c);
    }

    public final void start(String sessionId) {
        Assertions.assertFalse((boolean)this.isActive(), (String)"Session already started", (Object[])new Object[0]);
        Assertions.assertFalse((boolean)this.isStopping(), (String)"Session cannot be started because it is currently stopping.", (Object[])new Object[0]);
        this.m_id = (String)Assertions.assertNotNull((Object)sessionId, (String)"Session id must not be null", (Object[])new Object[0]);
        this.assignUserId();
        this.interceptLoadSession();
        this.m_active = true;
        this.fireSessionChangedEvent(new SessionEvent((ISession)this, 100));
        LOG.info("Server session started [session={}, user={}]", (Object)this, (Object)this.getUserId());
    }

    @ConfigOperation
    @Order(value=10.0)
    protected void execLoadSession() {
    }

    public String getId() {
        return this.m_id;
    }

    protected final void interceptLoadSession() {
        List<? extends IServerSessionExtension<? extends AbstractServerSession>> extensions = this.getAllExtensions();
        ServerSessionChains.ServerSessionLoadSessionChain chain = new ServerSessionChains.ServerSessionLoadSessionChain(extensions);
        chain.execLoadSession();
    }

    public void stop() {
        if (this.isStopping() || !this.isActive()) {
            return;
        }
        try {
            this.m_stopping = true;
            this.fireSessionChangedEvent(new SessionEvent((ISession)this, 105));
            ((ServerSessionProviderWithCache)BEANS.get(ServerSessionProviderWithCache.class)).remove(this);
            this.cancelRunningJobs();
        }
        finally {
            this.inactivateSession();
        }
    }

    protected void cancelRunningJobs() {
        ((RunMonitorCancelRegistry)BEANS.get(RunMonitorCancelRegistry.class)).cancelAllBySessionId(this.getId());
        Jobs.getJobManager().cancel(Jobs.newFutureFilterBuilder().andMatch((Predicate)new SessionFutureFilter((ISession)this)).andMatchNotFuture(new IFuture[]{(IFuture)IFuture.CURRENT.get()}).toFilter(), true);
    }

    protected void inactivateSession() {
        try {
            this.logoutSession();
        }
        finally {
            this.m_active = false;
            this.m_stopping = false;
            this.fireSessionChangedEvent(new SessionEvent((ISession)this, 110));
            this.m_sessionMetrics.sessionDestroyed(SESSION_TYPE);
            LOG.info("Server session stopped [session={}, user={}]", (Object)this, (Object)this.getUserId());
        }
    }

    protected void logoutSession() {
        BEANS.optional(ILogoutService.class).ifPresent(ILogoutService::logout);
    }

    public IFastListenerList<ISessionListener> sessionListeners() {
        return this.m_eventListeners;
    }

    protected void fireSessionChangedEvent(SessionEvent event) {
        this.sessionListeners().list().forEach(listener -> this.handleSessionEvent((ISessionListener)listener, event));
        BEANS.all(IGlobalSessionListener.class).forEach(listener -> this.handleSessionEvent((ISessionListener)listener, event));
    }

    protected void handleSessionEvent(ISessionListener listener, SessionEvent event) {
        try {
            listener.sessionChanged(event);
        }
        catch (RuntimeException e) {
            if (event.getType() != 110 && event.getType() != 105) {
                throw e;
            }
            LOG.warn("Error in session listener {}.", listener.getClass(), (Object)e);
        }
    }

    public String toString() {
        return super.toString() + "[id = " + this.getId() + "]";
    }

    protected static class LocalServerSessionExtension<OWNER extends AbstractServerSession>
    extends AbstractSerializableExtension<OWNER>
    implements IServerSessionExtension<OWNER> {
        private static final long serialVersionUID = 1L;

        public LocalServerSessionExtension(OWNER owner) {
            super(owner);
        }

        @Override
        public void execLoadSession(ServerSessionChains.ServerSessionLoadSessionChain chain) {
            ((AbstractServerSession)this.getOwner()).execLoadSession();
        }
    }
}

