/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.commons.servlet.filter.gzip;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Set;
import org.eclipse.scout.rt.server.commons.servlet.UrlHints;
import org.eclipse.scout.rt.server.commons.servlet.filter.gzip.GzipServletOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class GzipServletResponseWrapper
extends HttpServletResponseWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(GzipServletResponseWrapper.class);
    private PrintWriter m_writer;
    private ServletOutputStream m_outputStream;
    private final HttpServletRequest m_request;
    private final int m_compressThreshold;
    private final Set<String> m_contentTypes;
    private final boolean m_enableEmptyContentTypeLogging;

    public GzipServletResponseWrapper(HttpServletResponse response, HttpServletRequest request, int compressThreshold, Set<String> contentTypes, boolean enableEmptyContentTypeLogging) {
        super(response);
        this.m_request = request;
        this.m_compressThreshold = compressThreshold;
        this.m_contentTypes = contentTypes;
        this.m_enableEmptyContentTypeLogging = enableEmptyContentTypeLogging;
    }

    public HttpServletResponse getResponse() {
        return (HttpServletResponse)super.getResponse();
    }

    protected GzipServletOutputStream createGzipServletOutputStream(int compressThreshold, HttpServletResponse response) throws IOException {
        return new GzipServletOutputStream(compressThreshold, response);
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.m_writer != null) {
            throw new IllegalStateException("getWriter was previously called, getOutputStream is not available");
        }
        if (this.m_outputStream == null) {
            this.m_outputStream = this.getOrCreateServletOutputStream();
        }
        return this.m_outputStream;
    }

    protected ServletOutputStream getOrCreateServletOutputStream() throws IOException {
        if (!this.requiresGzipCompression(this.getContentType())) {
            return this.getResponse().getOutputStream();
        }
        return this.createGzipServletOutputStream(this.m_compressThreshold, this.getResponse());
    }

    public PrintWriter getWriter() throws IOException {
        if (this.m_writer != null) {
            return this.m_writer;
        }
        if (this.m_outputStream != null) {
            throw new IllegalStateException("getOutputStream was previously called, getWriter is not available");
        }
        this.m_outputStream = this.getOrCreateServletOutputStream();
        this.m_writer = new PrintWriter(new OutputStreamWriter((OutputStream)this.m_outputStream, this.getResponse().getCharacterEncoding()));
        return this.m_writer;
    }

    public void setContentLength(int len) {
    }

    public void setHeader(String name, String value) {
        if ("Content-Length".equalsIgnoreCase(name)) {
            return;
        }
        super.setHeader(name, value);
    }

    public void addHeader(String name, String value) {
        if ("Content-Length".equalsIgnoreCase(name)) {
            return;
        }
        super.addHeader(name, value);
    }

    public void flushBuffer() throws IOException {
        if (this.m_writer != null) {
            this.m_writer.flush();
        }
        if (this.m_outputStream != null) {
            this.m_outputStream.flush();
        }
        super.flushBuffer();
    }

    public void finish() throws IOException {
        if (this.m_writer != null) {
            this.m_writer.close();
            this.m_writer = null;
        }
        if (this.m_outputStream != null) {
            this.m_outputStream.close();
            this.m_outputStream = null;
        }
    }

    protected boolean requiresGzipCompression(String contentType) {
        if (!UrlHints.isCompressHint(this.m_request)) {
            return false;
        }
        if (this.m_request.isAsyncStarted()) {
            return false;
        }
        if (contentType == null) {
            if (this.m_enableEmptyContentTypeLogging) {
                LOG.warn("Content type of response is not defined for request path info {}.", (Object)this.m_request.getPathInfo());
            }
            return false;
        }
        contentType = contentType.split(";")[0];
        return this.m_contentTypes.contains(contentType);
    }
}

