/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.commons.servlet.filter.gzip;

import jakarta.servlet.AsyncEvent;
import jakarta.servlet.AsyncListener;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.server.commons.servlet.filter.gzip.GzipServletRequestWrapper;
import org.eclipse.scout.rt.server.commons.servlet.filter.gzip.GzipServletResponseWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class GzipServletFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(GzipServletFilter.class);
    public static final String ACCEPT_ENCODING = "Accept-Encoding";
    public static final String CONTENT_ENCODING = "Content-Encoding";
    public static final String GZIP = "gzip";
    public static final String CONTENT_TYPES = "text/html,text/css,text/xml,text/plain,application/json,application/javascript,image/svg+xml,text/vcard";
    private int m_minSize;
    private Set<String> m_contentTypes;
    private boolean m_enableEmptyContentTypeLogging;

    public void init(FilterConfig config) throws ServletException {
        this.m_minSize = Integer.parseInt((String)ObjectUtility.nvl((Object)config.getInitParameter("min_size"), (Object)"256"));
        this.m_contentTypes = CollectionUtility.hashSet((Object[])StringUtility.split((String)((String)ObjectUtility.nvl((Object)config.getInitParameter("content_types"), (Object)CONTENT_TYPES)), (String)","));
        this.m_enableEmptyContentTypeLogging = Boolean.parseBoolean((String)ObjectUtility.nvl((Object)config.getInitParameter("enable_empty_content_type_logging"), (Object)"true"));
        LOG.warn("Using deprecated {}", (Object)this.getClass().getName());
    }

    public void doFilter(ServletRequest req0, ServletResponse resp0, FilterChain chain) throws IOException, ServletException {
        Object req = (HttpServletRequest)req0;
        Object resp = (HttpServletResponse)resp0;
        if (this.requestHasGzipEncoding((HttpServletRequest)req)) {
            GzipServletRequestWrapper gzipReq = new GzipServletRequestWrapper((HttpServletRequest)req);
            req = gzipReq;
            if (LOG.isDebugEnabled()) {
                LOG.debug("GZIP request[size {}%, compressed: {}, uncompressed: {}]: {}", new Object[]{gzipReq.getCompressedLength() * 100 / gzipReq.getUncompressedLength(), gzipReq.getCompressedLength(), gzipReq.getUncompressedLength(), req.getPathInfo()});
            }
        }
        if (this.m_minSize >= 0 && this.requestAcceptsGzipEncoding((HttpServletRequest)req)) {
            resp = new GzipServletResponseWrapper((HttpServletResponse)resp, (HttpServletRequest)req, this.m_minSize, Collections.unmodifiableSet(this.m_contentTypes), this.m_enableEmptyContentTypeLogging);
        }
        chain.doFilter((ServletRequest)req, (ServletResponse)resp);
        if (!req.isAsyncStarted()) {
            if (resp instanceof GzipServletResponseWrapper) {
                GzipServletResponseWrapper gzipResp = (GzipServletResponseWrapper)((Object)resp);
                gzipResp.finish();
            }
        } else {
            req.getAsyncContext().addListener(new AsyncListener(){

                public void onComplete(AsyncEvent event) throws IOException {
                    ServletResponse resp = event.getSuppliedResponse();
                    if (resp instanceof GzipServletResponseWrapper) {
                        GzipServletResponseWrapper gzipResp = (GzipServletResponseWrapper)resp;
                        gzipResp.finish();
                    }
                }

                public void onTimeout(AsyncEvent event) {
                }

                public void onError(AsyncEvent event) {
                }

                public void onStartAsync(AsyncEvent event) {
                }
            });
        }
    }

    protected boolean requestHasGzipEncoding(HttpServletRequest req) {
        String h = req.getHeader(CONTENT_ENCODING);
        return h != null && h.contains(GZIP);
    }

    protected boolean requestAcceptsGzipEncoding(HttpServletRequest req) {
        String h = req.getHeader(ACCEPT_ENCODING);
        return h != null && h.contains(GZIP);
    }

    public void destroy() {
    }
}

