/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.commons.servlet;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.config.CONFIG;
import org.eclipse.scout.rt.platform.util.BooleanUtility;
import org.eclipse.scout.rt.platform.util.LazyValue;
import org.eclipse.scout.rt.server.commons.ServerCommonsConfigProperties;
import org.eclipse.scout.rt.server.commons.servlet.CookieUtility;
import org.eclipse.scout.rt.server.commons.servlet.UrlHints;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class UrlHintsHelper {
    private static final Logger LOG = LoggerFactory.getLogger(UrlHintsHelper.class);
    private static final LazyValue<Boolean> UPDATE_ENABLED = new LazyValue(() -> (Boolean)CONFIG.getPropertyValue(ServerCommonsConfigProperties.UrlHintsEnabledProperty.class));
    private static final LazyValue<UrlHints> DEFAULT_HINTS = new LazyValue(() -> {
        UrlHints urlHints = (UrlHints)BEANS.get(UrlHints.class);
        urlHints.setReadOnly();
        return urlHints;
    });
    private static final String URL_HINTS_COOKIE_NAME = "scout.urlHints";
    private static final String CACHED_URL_HINTS_ATTRIBUTE_NAME = "scout.cachedUrlHints";

    public UrlHints getDefaultUrlHints() {
        return (UrlHints)DEFAULT_HINTS.get();
    }

    public boolean isUpdateEnabled() {
        return BooleanUtility.nvl((Boolean)((Boolean)UPDATE_ENABLED.get()));
    }

    public UrlHints fromCookieString(String cookieString) {
        UrlHints result = (UrlHints)BEANS.get(UrlHints.class);
        result.setFromCookieString(cookieString);
        result.setChanged(false);
        return result;
    }

    public UrlHints fromCookie(Cookie cookie) {
        return this.fromCookieString(cookie == null ? null : cookie.getValue());
    }

    public void updateHints(HttpServletRequest req, HttpServletResponse resp) {
        if (req == null || !this.isUpdateEnabled()) {
            return;
        }
        UrlHints urlHints = this.getUrlHints(req);
        urlHints.setFromUrlParams(req);
        if (urlHints.equals(((UrlHintsHelper)BEANS.get(UrlHintsHelper.class)).getDefaultUrlHints())) {
            Cookie cookie = CookieUtility.getCookieByName(req, URL_HINTS_COOKIE_NAME);
            if (cookie != null) {
                LOG.info("Deleting existing URL hints cookie (reset to default values)");
                CookieUtility.deleteCookie(resp, URL_HINTS_COOKIE_NAME);
            }
        } else if (urlHints.isChanged()) {
            LOG.info("Setting URL hints cookie to {} [{}]", (Object)urlHints.toCookieString(), (Object)urlHints.toHumanReadableString());
            CookieUtility.addSessionCookie(resp, URL_HINTS_COOKIE_NAME, urlHints.toCookieString());
        }
    }

    protected UrlHints getUrlHints(HttpServletRequest req) {
        if (req == null || !this.isUpdateEnabled()) {
            return this.getDefaultUrlHints();
        }
        UrlHints urlHints = (UrlHints)req.getAttribute(CACHED_URL_HINTS_ATTRIBUTE_NAME);
        if (urlHints != null) {
            return urlHints;
        }
        Cookie cookie = CookieUtility.getCookieByName(req, URL_HINTS_COOKIE_NAME);
        urlHints = this.fromCookie(cookie);
        req.setAttribute(CACHED_URL_HINTS_ATTRIBUTE_NAME, (Object)urlHints);
        return urlHints;
    }

    public boolean isInspectorHint(HttpServletRequest req) {
        return this.getUrlHints(req).isInspector();
    }

    public boolean isCacheHint(HttpServletRequest req) {
        return this.getUrlHints(req).isCache();
    }

    public boolean isMinifyHint(HttpServletRequest req) {
        return this.getUrlHints(req).isMinify();
    }

    @Deprecated
    public boolean isCompressHint(HttpServletRequest req) {
        return this.getUrlHints(req).isCompress();
    }
}

