/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.commons.servlet;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.concurrent.TimeUnit;
import org.eclipse.scout.rt.platform.util.Assertions;

public final class CookieUtility {
    private CookieUtility() {
    }

    public static Cookie getCookieByName(HttpServletRequest req, String cookieName) {
        Assertions.assertNotNull((Object)req, (String)"Missing HTTP servlet request", (Object[])new Object[0]);
        Cookie[] cookies = req.getCookies();
        if (cookies == null || cookieName == null) {
            return null;
        }
        Cookie[] cookieArray = cookies;
        int n = cookies.length;
        int n2 = 0;
        while (n2 < n) {
            Cookie cookie = cookieArray[n2];
            if (cookieName.equals(cookie.getName())) {
                return cookie;
            }
            ++n2;
        }
        return null;
    }

    public static void addPersistentCookie(HttpServletResponse resp, String cookieName, String value) {
        CookieUtility.addPersistentCookie(resp, cookieName, value, (int)TimeUnit.DAYS.toSeconds(30L));
    }

    public static void addPersistentCookie(HttpServletResponse resp, String cookieName, String value, int maxAgeInSeconds) {
        Cookie cookie = new Cookie(cookieName, value);
        cookie.setMaxAge(maxAgeInSeconds);
        resp.addCookie(cookie);
    }

    public static void addPersistentCookie(HttpServletResponse resp, String cookieName, String value, long maxAgeInSeconds) {
        CookieUtility.addPersistentCookie(resp, cookieName, value, (int)maxAgeInSeconds);
    }

    public static void addSessionCookie(HttpServletResponse resp, String cookieName, String value) {
        Cookie cookie = new Cookie(cookieName, value);
        cookie.setMaxAge(-1);
        resp.addCookie(cookie);
    }

    public static void deleteCookie(HttpServletResponse resp, String cookieName) {
        Cookie cookie = new Cookie(cookieName, "");
        cookie.setMaxAge(0);
        resp.addCookie(cookie);
    }
}

