/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.commons.servlet;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.AsyncEvent;
import jakarta.servlet.AsyncListener;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.eclipse.scout.rt.server.commons.servlet.AlreadyInvalidatedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHttpServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractHttpServlet.class);

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.wrap(req, resp, (httpServletRequest, httpServletResponse) -> super.service(httpServletRequest, httpServletResponse));
    }

    protected void wrap(HttpServletRequest req, HttpServletResponse resp, HttpServletConsumer consumer) throws ServletException, IOException {
        P_HttpInvocationHandler requestProxyHandler = new P_HttpInvocationHandler(req);
        P_HttpInvocationHandler responseProxyHandler = new P_HttpInvocationHandler(resp);
        try {
            HttpServletRequest request = (HttpServletRequest)Proxy.newProxyInstance(HttpServletRequest.class.getClassLoader(), new Class[]{HttpServletRequest.class}, (InvocationHandler)requestProxyHandler);
            HttpServletResponse response = (HttpServletResponse)Proxy.newProxyInstance(HttpServletResponse.class.getClassLoader(), new Class[]{HttpServletResponse.class}, (InvocationHandler)responseProxyHandler);
            consumer.service(request, response);
        }
        finally {
            this.invalidateRequestAndResponse(req, requestProxyHandler, responseProxyHandler);
        }
    }

    protected void invalidateRequestAndResponse(HttpServletRequest req, P_HttpInvocationHandler requestProxyHandler, P_HttpInvocationHandler responseProxyHandler) {
        if (req.isAsyncStarted()) {
            this.invalidateAsync(req, requestProxyHandler, responseProxyHandler);
        } else {
            requestProxyHandler.invalidate();
            responseProxyHandler.invalidate();
        }
    }

    protected void invalidateAsync(HttpServletRequest req, final P_HttpInvocationHandler requestProxyHandler, final P_HttpInvocationHandler responseProxyHandler) {
        AsyncContext asyncContext = req.getAsyncContext();
        try {
            asyncContext.addListener(new AsyncListener(){

                public void onComplete(AsyncEvent event) {
                    requestProxyHandler.invalidate();
                    responseProxyHandler.invalidate();
                }

                public void onTimeout(AsyncEvent event) {
                    requestProxyHandler.invalidate();
                    responseProxyHandler.invalidate();
                }

                public void onError(AsyncEvent event) {
                    requestProxyHandler.invalidate();
                    responseProxyHandler.invalidate();
                }

                public void onStartAsync(AsyncEvent event) {
                }
            });
            asyncContext.getRequest();
        }
        catch (IllegalStateException e) {
            LOG.debug("Error during async-listener registration; invalidating request and response", (Throwable)e);
            requestProxyHandler.invalidate();
            responseProxyHandler.invalidate();
        }
    }

    @FunctionalInterface
    protected static interface HttpServletConsumer {
        public void service(HttpServletRequest var1, HttpServletResponse var2) throws ServletException, IOException;
    }

    protected final class P_HttpInvocationHandler
    implements InvocationHandler {
        private boolean m_valid = true;
        private final Object m_origin;

        public P_HttpInvocationHandler(Object origin) {
            this.m_origin = origin;
        }

        private void invalidate() {
            this.m_valid = false;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (!this.m_valid) {
                throw new AlreadyInvalidatedException(method, this.m_origin);
            }
            return method.invoke(this.m_origin, args);
        }
    }
}

