/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.commons.opentelemetry;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.api.instrumenter.ContextCustomizer;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.SpanKindExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.semconv.http.HttpServerAttributesExtractor;
import io.opentelemetry.instrumentation.api.semconv.http.HttpServerAttributesGetter;
import io.opentelemetry.instrumentation.api.semconv.http.HttpServerMetrics;
import io.opentelemetry.instrumentation.api.semconv.http.HttpServerRoute;
import io.opentelemetry.instrumentation.api.semconv.http.HttpSpanNameExtractor;
import io.opentelemetry.instrumentation.api.semconv.http.HttpSpanStatusExtractor;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.config.CONFIG;
import org.eclipse.scout.rt.platform.opentelemetry.OpenTelemetryProperties;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.server.commons.opentelemetry.SpanNamePropagationFromDownstream;

@ApplicationScoped
public class OpenTelemetryFilterInstrumenterFactory {
    public static final String INSTRUMENTATION_NAME = "scout.OpenTelemetryFilter";

    public Instrumenter<HttpServletRequest, HttpServletResponse> createInstrumenter() {
        OpenTelemetryServerHttpAttributesGetter attributesGetter = OpenTelemetryServerHttpAttributesGetter.INSTANCE;
        SpanNameExtractor spanNameExtractor = HttpSpanNameExtractor.create((HttpServerAttributesGetter)attributesGetter);
        return Instrumenter.builder((OpenTelemetry)GlobalOpenTelemetry.get(), (String)INSTRUMENTATION_NAME, (SpanNameExtractor)spanNameExtractor).setSpanStatusExtractor(HttpSpanStatusExtractor.create((HttpServerAttributesGetter)attributesGetter)).addAttributesExtractor(HttpServerAttributesExtractor.builder((HttpServerAttributesGetter)attributesGetter).build()).addContextCustomizer((ContextCustomizer)new SpanNamePropagationFromDownstream()).addContextCustomizer(HttpServerRoute.builder((HttpServerAttributesGetter)attributesGetter).build()).addOperationMetrics(HttpServerMetrics.get()).setEnabled(((Boolean)CONFIG.getPropertyValue(OpenTelemetryProperties.OpenTelemetryTracingEnabledProperty.class)).booleanValue()).buildInstrumenter(SpanKindExtractor.alwaysServer());
    }

    public static enum OpenTelemetryServerHttpAttributesGetter implements HttpServerAttributesGetter<HttpServletRequest, HttpServletResponse>
    {
        INSTANCE;


        public String getUrlScheme(HttpServletRequest httpServletRequest) {
            return httpServletRequest.getProtocol();
        }

        public String getUrlPath(HttpServletRequest httpServletRequest) {
            return httpServletRequest.getRequestURI();
        }

        public String getUrlQuery(HttpServletRequest httpServletRequest) {
            return httpServletRequest.getQueryString();
        }

        public String getHttpRequestMethod(HttpServletRequest httpServletRequest) {
            return httpServletRequest.getMethod();
        }

        public List<String> getHttpRequestHeader(HttpServletRequest httpServletRequest, String name) {
            Enumeration values = httpServletRequest.getHeaders(name);
            return Collections.list(values);
        }

        public Integer getHttpResponseStatusCode(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Throwable error) {
            return httpServletResponse.getStatus();
        }

        public List<String> getHttpResponseHeader(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String name) {
            return CollectionUtility.arrayList((Collection)httpServletResponse.getHeaders(name));
        }

        public String getHttpRoute(HttpServletRequest httpServletRequest) {
            return httpServletRequest.getRequestURI();
        }
    }
}

