/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.commons.id;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.scout.rt.platform.util.EnumerationUtility;
import org.eclipse.scout.rt.platform.util.StringUtility;

public class IdSignatureFilter
implements Filter {
    public static final String ID_SIGNATURE_HTTP_HEADER = "X-ScoutIdSignature";

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        SignatureHttpServletRequestWrapper req = this.createSignatureRequest((HttpServletRequest)request);
        chain.doFilter((ServletRequest)req, response);
    }

    protected SignatureHttpServletRequestWrapper createSignatureRequest(HttpServletRequest request) {
        return new SignatureHttpServletRequestWrapper(request);
    }

    public static class SignatureHttpServletRequestWrapper
    extends HttpServletRequestWrapper {
        protected final Map<String, String> m_additionalHeaders = Map.of("X-ScoutIdSignature", Boolean.TRUE.toString());

        public SignatureHttpServletRequestWrapper(HttpServletRequest request) {
            super(request);
        }

        public String getHeader(String name) {
            return this.m_additionalHeaders.entrySet().stream().filter(entry -> StringUtility.equalsIgnoreCase((String)name, (String)((String)entry.getKey()))).map(Map.Entry::getValue).findFirst().orElseGet(() -> super.getHeader(name));
        }

        public Enumeration<String> getHeaders(String name) {
            return EnumerationUtility.asEnumeration(Stream.concat(EnumerationUtility.asStream((Enumeration)super.getHeaders(name)), this.m_additionalHeaders.entrySet().stream().filter(entry -> StringUtility.equalsIgnoreCase((String)name, (String)((String)entry.getKey()))).map(Map.Entry::getValue)).iterator());
        }

        public Enumeration<String> getHeaderNames() {
            return Collections.enumeration(Stream.concat(EnumerationUtility.asStream((Enumeration)super.getHeaderNames()), this.m_additionalHeaders.keySet().stream()).collect(Collectors.toSet()));
        }
    }
}

