/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.commons.authentication.token;

import java.util.List;
import java.util.function.Predicate;
import org.eclipse.scout.rt.platform.Bean;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.TokenUtility;
import org.eclipse.scout.rt.server.commons.authentication.token.ITokenVerifier;

@Bean
public class SingleStringTokenVerifier
implements ITokenVerifier {
    protected Predicate<char[]> m_verifier;

    public SingleStringTokenVerifier init(Predicate<char[]> verifier) {
        Assertions.assertNotNull(verifier, (String)"Verifier must not be null", (Object[])new Object[0]);
        this.m_verifier = verifier;
        return this;
    }

    @Override
    public int verify(List<byte[]> tokenParts) {
        if (CollectionUtility.size(tokenParts) != 1) {
            return 4;
        }
        return this.m_verifier.test(TokenUtility.toChars((byte[])tokenParts.get(0))) ? 1 : 2;
    }
}

