/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.commons.authentication.token;

import java.security.Principal;
import java.util.List;
import java.util.function.Function;
import org.eclipse.scout.rt.platform.Bean;
import org.eclipse.scout.rt.platform.security.SimplePrincipal;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.TokenUtility;
import org.eclipse.scout.rt.server.commons.authentication.token.ITokenPrincipalProducer;

@Bean
public class SingleStringTokenPrincipalProducer
implements ITokenPrincipalProducer {
    protected Function<char[], String> m_tokenToPrincipalMapper;

    public SingleStringTokenPrincipalProducer init(Function<char[], String> tokenToPrincipalMapper) {
        Assertions.assertNotNull(tokenToPrincipalMapper, (String)"Principal mapper must not be null", (Object[])new Object[0]);
        this.m_tokenToPrincipalMapper = tokenToPrincipalMapper;
        return this;
    }

    @Override
    public Principal produce(List<byte[]> tokenParts) {
        if (CollectionUtility.size(tokenParts) != 1) {
            return null;
        }
        return new SimplePrincipal(this.m_tokenToPrincipalMapper.apply(TokenUtility.toChars((byte[])tokenParts.get(0))));
    }
}

