/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.commons.authentication;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.security.Principal;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.security.IPrincipalProducer;
import org.eclipse.scout.rt.platform.security.IPrincipalVerifier;
import org.eclipse.scout.rt.platform.security.SimplePrincipalProducer;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.server.commons.authentication.IAccessController;
import org.eclipse.scout.rt.server.commons.authentication.PathInfoFilter;
import org.eclipse.scout.rt.server.commons.authentication.ServletFilterHelper;

public class TrivialAccessController
implements IAccessController {
    private TrivialAuthConfig m_config;

    public TrivialAccessController init(TrivialAuthConfig config) {
        this.m_config = config;
        return this;
    }

    @Override
    public boolean handle(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!this.m_config.isEnabled()) {
            return false;
        }
        ServletFilterHelper helper = (ServletFilterHelper)BEANS.get(ServletFilterHelper.class);
        AuthenticationStatus authenticationStatus = this.getAuthenticationStatus(request);
        if (helper.isUnloadRequest(request) && !authenticationStatus.isAuthenticated()) {
            response.sendError(403);
            return true;
        }
        switch ((String)ObjectUtility.nvl((Object)request.getPathInfo(), (Object)"")) {
            case "/login": {
                if (this.m_config.isHandleAuthentication()) {
                    this.handleLoginRequest(request, response);
                    return true;
                }
                return false;
            }
            case "/logout": {
                if (this.m_config.isHandleAuthentication()) {
                    this.handleLogoutRequest(request, response);
                    return true;
                }
                return false;
            }
            case "/legacy-browsers.js": 
            case "/unsupported-browser.html": {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
                return true;
            }
            case "/auth": {
                return false;
            }
        }
        return this.handleRequest(request, authenticationStatus, response, chain);
    }

    @Override
    public void destroy() {
    }

    protected boolean handleRequest(HttpServletRequest request, AuthenticationStatus authenticationStatus, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        ServletFilterHelper helper = (ServletFilterHelper)BEANS.get(ServletFilterHelper.class);
        if (helper.redirectIncompleteBasePath(request, response, false)) {
            return true;
        }
        if (authenticationStatus.getStatus() == AuthenticationStatusType.SUBJECT_VALID) {
            if (helper.redirectAfterLogin(request, response, helper)) {
                return true;
            }
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return true;
        }
        if (authenticationStatus.getStatus() == AuthenticationStatusType.PRINCIPAL_INVALID) {
            return false;
        }
        if (authenticationStatus.getStatus() == AuthenticationStatusType.PRINCIPAL_VALID) {
            if (helper.redirectAfterLogin(request, response, helper)) {
                return true;
            }
            helper.continueChainAsSubject(authenticationStatus.getPrincipal(), request, response, chain);
            return true;
        }
        if (this.m_config.getExclusionFilter().accepts(StringUtility.emptyIfNull((Object)request.getServletPath()) + StringUtility.emptyIfNull((Object)request.getPathInfo()))) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return true;
        }
        return false;
    }

    protected void handleLoginRequest(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (this.m_config.isLoginPageInstalled()) {
            ((ServletFilterHelper)BEANS.get(ServletFilterHelper.class)).forwardToLoginForm(request, response);
        }
    }

    protected void handleLogoutRequest(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ((ServletFilterHelper)BEANS.get(ServletFilterHelper.class)).doLogout(request);
        if (this.m_config.isLoginPageInstalled()) {
            ((ServletFilterHelper)BEANS.get(ServletFilterHelper.class)).forwardToLogoutForm(request, response);
        }
    }

    protected AuthenticationStatus getAuthenticationStatus(HttpServletRequest request) {
        if (((ServletFilterHelper)BEANS.get(ServletFilterHelper.class)).isRunningWithValidSubject(request)) {
            return new AuthenticationStatus(AuthenticationStatusType.SUBJECT_VALID);
        }
        Principal principal = ((ServletFilterHelper)BEANS.get(ServletFilterHelper.class)).findPrincipal(request, this.m_config.getPrincipalProducer());
        if (principal == null) {
            return new AuthenticationStatus(AuthenticationStatusType.NONE);
        }
        if (this.m_config.m_principalVerifier == null) {
            return new AuthenticationStatus(AuthenticationStatusType.PRINCIPAL_VALID, principal);
        }
        return new AuthenticationStatus(this.m_config.m_principalVerifier.verify(principal) ? AuthenticationStatusType.PRINCIPAL_VALID : AuthenticationStatusType.PRINCIPAL_INVALID, principal);
    }

    protected class AuthenticationStatus {
        private final AuthenticationStatusType m_status;
        private final Principal m_principal;

        public AuthenticationStatus(AuthenticationStatusType status) {
            Assertions.assertNotNull((Object)((Object)status));
            this.m_status = status;
            this.m_principal = null;
        }

        public AuthenticationStatus(AuthenticationStatusType status, Principal principal) {
            Assertions.assertNotNull((Object)((Object)status));
            Assertions.assertNotNull((Object)principal);
            this.m_status = status;
            this.m_principal = principal;
        }

        public Principal getPrincipal() {
            return this.m_principal;
        }

        public AuthenticationStatusType getStatus() {
            return this.m_status;
        }

        public boolean isAuthenticated() {
            return ObjectUtility.isOneOf((Object)((Object)this.m_status), (Object)((Object)AuthenticationStatusType.SUBJECT_VALID), (Object[])new Object[]{AuthenticationStatusType.PRINCIPAL_VALID});
        }
    }

    protected static enum AuthenticationStatusType {
        NONE,
        SUBJECT_VALID,
        PRINCIPAL_VALID,
        PRINCIPAL_INVALID;

    }

    public static class TrivialAuthConfig {
        private boolean m_enabled = true;
        private IPrincipalProducer m_principalProducer = (IPrincipalProducer)BEANS.get(SimplePrincipalProducer.class);
        private PathInfoFilter m_exclusionFilter;
        private boolean m_handleAuthentication = true;
        private boolean m_loginPageInstalled = false;
        private IPrincipalVerifier m_principalVerifier;

        public boolean isEnabled() {
            return this.m_enabled;
        }

        public TrivialAuthConfig withEnabled(boolean enabled) {
            this.m_enabled = enabled;
            return this;
        }

        public IPrincipalProducer getPrincipalProducer() {
            return this.m_principalProducer;
        }

        public TrivialAuthConfig withPrincipalProducer(IPrincipalProducer principalProducer) {
            this.m_principalProducer = principalProducer;
            return this;
        }

        public IPrincipalVerifier getPrincipalVerifier() {
            return this.m_principalVerifier;
        }

        public TrivialAuthConfig withPrincipalVerifier(IPrincipalVerifier principalVerifier) {
            this.m_principalVerifier = principalVerifier;
            return this;
        }

        @Deprecated
        public PathInfoFilter getPathInfoFilter() {
            return this.getExclusionFilter();
        }

        public PathInfoFilter getExclusionFilter() {
            return this.m_exclusionFilter;
        }

        public TrivialAuthConfig withExclusionFilter(String exclusionFilter) {
            this.m_exclusionFilter = new PathInfoFilter(exclusionFilter);
            return this;
        }

        public boolean isHandleAuthentication() {
            return this.m_handleAuthentication;
        }

        public TrivialAuthConfig withHandleAuthentication(boolean handleAuthentication) {
            this.m_handleAuthentication = handleAuthentication;
            return this;
        }

        public boolean isLoginPageInstalled() {
            return this.m_loginPageInstalled;
        }

        public TrivialAuthConfig withLoginPageInstalled(boolean loginPageInstalled) {
            this.m_loginPageInstalled = loginPageInstalled;
            return this;
        }
    }
}

