/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.commons.authentication;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.security.Principal;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.security.IPrincipalProducer2;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.server.commons.authentication.IAccessController;
import org.eclipse.scout.rt.server.commons.authentication.ServletFilterHelper;
import org.eclipse.scout.rt.shared.servicetunnel.http.DefaultAuthToken;
import org.eclipse.scout.rt.shared.servicetunnel.http.DefaultAuthTokenPrincipalProducer;
import org.eclipse.scout.rt.shared.servicetunnel.http.DefaultAuthTokenVerifier;

public class ServiceTunnelAccessTokenAccessController
implements IAccessController {
    private ServiceTunnelAccessTokenAuthConfig m_config;
    private boolean m_enabled;

    public ServiceTunnelAccessTokenAccessController init() {
        this.init(new ServiceTunnelAccessTokenAuthConfig());
        return this;
    }

    public ServiceTunnelAccessTokenAccessController init(ServiceTunnelAccessTokenAuthConfig config) {
        this.m_config = config;
        this.m_enabled = config.isEnabled() && config.getTokenClazz() != null && config.getTokenVerifier() != null && config.getTokenVerifier().isEnabled() && config.getPrincipalProducer2() != null;
        return this;
    }

    @Override
    public boolean handle(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!this.m_enabled) {
            return false;
        }
        String tokenString = request.getHeader("X-ScoutAccessToken");
        if (StringUtility.isNullOrEmpty((CharSequence)tokenString)) {
            return false;
        }
        DefaultAuthToken token = ((DefaultAuthToken)BEANS.get(this.m_config.getTokenClazz())).read(tokenString);
        if (!this.m_config.getTokenVerifier().verify(token)) {
            this.fail(response);
            return true;
        }
        Principal principal = this.m_config.getPrincipalProducer2().produce(token.getUserId(), token.getCustomArgs());
        ((ServletFilterHelper)BEANS.get(ServletFilterHelper.class)).continueChainAsSubject(principal, request, response, chain);
        return true;
    }

    @Override
    public void destroy() {
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    protected void fail(HttpServletResponse resp) throws IOException {
        resp.sendError(403);
    }

    public static class ServiceTunnelAccessTokenAuthConfig {
        private Class<? extends DefaultAuthToken> m_tokenClazz = DefaultAuthToken.class;
        private DefaultAuthTokenVerifier m_tokenVerifier = (DefaultAuthTokenVerifier)BEANS.get(DefaultAuthTokenVerifier.class);
        private boolean m_enabled = true;
        private IPrincipalProducer2 m_principalProducer = (IPrincipalProducer2)BEANS.get(DefaultAuthTokenPrincipalProducer.class);

        public Class<? extends DefaultAuthToken> getTokenClazz() {
            return this.m_tokenClazz;
        }

        public ServiceTunnelAccessTokenAuthConfig withTokenClazz(Class<? extends DefaultAuthToken> tokenClazz) {
            this.m_tokenClazz = tokenClazz;
            return this;
        }

        public DefaultAuthTokenVerifier getTokenVerifier() {
            return this.m_tokenVerifier;
        }

        public ServiceTunnelAccessTokenAuthConfig withTokenVerifier(DefaultAuthTokenVerifier tokenVerifier) {
            this.m_tokenVerifier = tokenVerifier;
            return this;
        }

        public boolean isEnabled() {
            return this.m_enabled;
        }

        public ServiceTunnelAccessTokenAuthConfig withEnabled(boolean enabled) {
            this.m_enabled = enabled;
            return this;
        }

        public IPrincipalProducer2 getPrincipalProducer2() {
            return this.m_principalProducer;
        }

        public ServiceTunnelAccessTokenAuthConfig withPrincipalProducer2(IPrincipalProducer2 principalProducer) {
            this.m_principalProducer = principalProducer;
            return this;
        }
    }
}

