/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.commons;

import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.scout.rt.platform.util.IOUtility;

public class BufferedServletInputStream
extends ServletInputStream {
    private final ByteArrayInputStream m_data;
    private final byte[] m_rawData;
    private volatile Object m_readListener;
    private volatile boolean m_finished = false;

    public BufferedServletInputStream(InputStream source, int len) {
        this(IOUtility.readBytes((InputStream)source, (int)len));
    }

    public BufferedServletInputStream(InputStream source) {
        this(IOUtility.readBytes((InputStream)source));
    }

    public BufferedServletInputStream(byte[] data) {
        this.m_rawData = data;
        this.m_data = new ByteArrayInputStream(data);
    }

    public boolean isFinished() {
        return this.m_finished;
    }

    public byte[] getData() {
        return this.m_rawData;
    }

    public boolean isReady() {
        return true;
    }

    public void setReadListener(ReadListener readListener) {
        if (readListener == null) {
            throw new NullPointerException("readlistener may not be null.");
        }
        this.m_readListener = readListener;
        try {
            readListener.onDataAvailable();
        }
        catch (IOException e) {
            readListener.onError((Throwable)e);
        }
    }

    public int read() throws IOException {
        try {
            int next = this.m_data.read();
            if (next < 0) {
                this.m_finished = true;
                ReadListener listener = (ReadListener)this.m_readListener;
                if (listener != null) {
                    listener.onAllDataRead();
                }
            }
            return next;
        }
        catch (IOException e) {
            ReadListener listener = (ReadListener)this.m_readListener;
            if (listener != null) {
                listener.onError((Throwable)e);
            }
            throw e;
        }
    }

    public int getLength() {
        return this.m_rawData.length;
    }
}

