/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.server.app;

import java.util.List;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.scout.rt.app.filter.ExceptionFilter;
import org.eclipse.scout.rt.jetty.IServletContributor;
import org.eclipse.scout.rt.jetty.IServletFilterContributor;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.server.ServiceTunnelServlet;
import org.eclipse.scout.rt.server.commons.healthcheck.HealthCheckServlet;

public final class ServerServletContributors {
    private ServerServletContributors() {
    }

    @Order(value=1000.0)
    public static class AuthFilterContributor
    implements IServletFilterContributor {
        public void contribute(ServletContextHandler handler) {
        }

        protected List<String> getFilterExcludes() {
            return CollectionUtility.arrayList((Object)"/status");
        }
    }

    @Order(value=750.0)
    public static class ExceptionFilterContributor
    implements IServletFilterContributor {
        public void contribute(ServletContextHandler handler) {
            handler.addFilter(ExceptionFilter.class, "/*", null);
        }
    }

    @Order(value=2000.0)
    public static class ServiceTunnelServletContributor
    implements IServletContributor {
        public void contribute(ServletContextHandler handler) {
            handler.addServlet(ServiceTunnelServlet.class, "/process");
        }
    }

    @Order(value=1000.0)
    public static class StatusServletContributor
    implements IServletContributor {
        public void contribute(ServletContextHandler handler) {
            handler.addServlet(HealthCheckServlet.class, "/status");
        }
    }
}

