/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.security;

import java.security.Permission;
import java.util.stream.Stream;
import org.eclipse.scout.rt.dataobject.exception.AccessForbiddenException;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.text.TEXTS;
import org.eclipse.scout.rt.security.IAccessControlService;
import org.eclipse.scout.rt.security.IPermission;
import org.eclipse.scout.rt.security.IPermissionCollection;
import org.eclipse.scout.rt.security.PermissionLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class AccessSupport {
    private static final Logger LOG = LoggerFactory.getLogger(AccessSupport.class);

    public boolean check(Permission p) {
        boolean implies = ((IAccessControlService)BEANS.get(IAccessControlService.class)).getPermissions().implies(p);
        LOG.trace("check({}): {}", (Object)p, (Object)implies);
        return implies;
    }

    public void checkAndThrow(Permission p) {
        if (!this.check(p)) {
            LOG.debug("checkAndThrow(p) failed, throwing exception");
            throw this.getAccessCheckFailedException(p);
        }
    }

    public boolean checkAny(Permission ... permissions) {
        if (permissions == null) {
            LOG.trace("checkAny(null) failed, no permissions supplied");
            return false;
        }
        IPermissionCollection c = ((IAccessControlService)BEANS.get(IAccessControlService.class)).getPermissions();
        boolean anyImplies = Stream.of(permissions).anyMatch(c::implies);
        LOG.trace("checkAny({}): {}", (Object)permissions, (Object)anyImplies);
        return anyImplies;
    }

    public void checkAnyAndThrow(Permission ... permissions) {
        if (!this.checkAny(permissions)) {
            if (permissions == null || permissions.length == 0) {
                throw this.getDefaultAccessCheckFailedException();
            }
            throw this.getAccessCheckFailedException(permissions[0]);
        }
    }

    public boolean checkAll(Permission ... permissions) {
        if (permissions == null) {
            LOG.trace("checkAll(null) failed, no permissions supplied");
            return false;
        }
        IPermissionCollection c = ((IAccessControlService)BEANS.get(IAccessControlService.class)).getPermissions();
        boolean allImplies = Stream.of(permissions).allMatch(c::implies);
        LOG.trace("checkAll({}): {}", (Object)permissions, (Object)allImplies);
        return allImplies;
    }

    public void checkAllAndThrow(Permission ... permissions) {
        if (permissions == null || permissions.length == 0) {
            throw this.getDefaultAccessCheckFailedException();
        }
        IPermissionCollection c = ((IAccessControlService)BEANS.get(IAccessControlService.class)).getPermissions();
        Stream.of(permissions).forEach(p -> {
            if (!c.implies((Permission)p)) {
                throw this.getAccessCheckFailedException((Permission)p);
            }
        });
    }

    public AccessForbiddenException getAccessCheckFailedException(Permission p) {
        if (p instanceof IPermission) {
            return this.getAccessCheckFailedException((IPermission)((Object)p));
        }
        return this.getDefaultAccessCheckFailedException().withContextInfo("permission", (Object)"{}", new Object[]{p});
    }

    protected AccessForbiddenException getAccessCheckFailedException(IPermission p) {
        return new AccessForbiddenException(p.getAccessCheckFailedMessage(), new Object[0]).withContextInfo("permission", (Object)"{}", new Object[]{p});
    }

    public AccessForbiddenException getDefaultAccessCheckFailedException() {
        return new AccessForbiddenException(TEXTS.get((String)"YouAreNotAuthorizedToPerformThisAction"), new Object[0]);
    }

    public PermissionLevel getGrantedPermissionLevel(IPermission permission) {
        PermissionLevel grantedPermissionLevel = ((IAccessControlService)BEANS.get(IAccessControlService.class)).getPermissions().getGrantedPermissionLevel(permission);
        LOG.trace("getGrantedPermissionLevel({}): {}", (Object)permission, (Object)grantedPermissionLevel);
        return grantedPermissionLevel;
    }
}

