/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.security;

import java.io.Serializable;
import java.security.PermissionCollection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.security.IPermissionCollection;

public abstract class AbstractPermissionCollection
extends PermissionCollection
implements IPermissionCollection {
    private static final long serialVersionUID = 1L;
    private final Map<Class<?>, Object> m_values = new HashMap();

    protected void assertNotReadOnly() {
        Assertions.assertFalse((boolean)this.isReadOnly(), (String)"PermissionCollection is read-only", (Object[])new Object[0]);
    }

    @Override
    public <T extends Serializable> T getValue(Class<T> valueType) {
        return (T)((Serializable)valueType.cast(this.m_values.get(valueType)));
    }

    @Override
    public Stream<Object> getValues() {
        return this.m_values.values().stream();
    }

    @Override
    public <T extends Serializable> void setValue(Class<T> valueType, T value) {
        this.assertNotReadOnly();
        Assertions.assertNotNull(valueType);
        if (value == null) {
            this.m_values.remove(valueType);
        } else {
            this.m_values.put(valueType, value);
        }
    }
}

