/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.mom.api;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.scout.rt.mom.api.IBiDestination;
import org.eclipse.scout.rt.mom.api.IDestination;
import org.eclipse.scout.rt.mom.api.IMessageListener;
import org.eclipse.scout.rt.mom.api.IMomImplementor;
import org.eclipse.scout.rt.mom.api.IRequestListener;
import org.eclipse.scout.rt.mom.api.ISubscription;
import org.eclipse.scout.rt.mom.api.ISubscriptionStats;
import org.eclipse.scout.rt.mom.api.PublishInput;
import org.eclipse.scout.rt.mom.api.SubscribeInput;
import org.eclipse.scout.rt.mom.api.marshaller.IMarshaller;
import org.eclipse.scout.rt.platform.util.IRegistrationHandle;

public class NullMomImplementor
implements IMomImplementor {
    @Override
    public void init(Map<Object, Object> properties) throws Exception {
    }

    @Override
    public String getId() {
        return NullMomImplementor.class.getSimpleName();
    }

    @Override
    public String getName() {
        return this.getId();
    }

    @Override
    public List<ISubscription> getSubscriptions() {
        return new ArrayList<ISubscription>();
    }

    @Override
    public <DTO> void publish(IDestination<DTO> destination, DTO transferObject, PublishInput input) {
    }

    @Override
    public <DTO> ISubscription subscribe(IDestination<DTO> destination, IMessageListener<DTO> listener, SubscribeInput input) {
        return new P_NullSubscription(destination, listener, null, input);
    }

    @Override
    public <REQUEST, REPLY> REPLY request(IBiDestination<REQUEST, REPLY> destination, REQUEST requestObject, PublishInput input) {
        return null;
    }

    @Override
    public <REQUEST, REPLY> ISubscription reply(IBiDestination<REQUEST, REPLY> destination, IRequestListener<REQUEST, REPLY> listener, SubscribeInput input) {
        return new P_NullSubscription(destination, null, listener, input);
    }

    @Override
    public void cancelDurableSubscription(String durableSubscriptionName) {
    }

    @Override
    public IRegistrationHandle registerMarshaller(IDestination<?> destination, IMarshaller marshaller) {
        return IRegistrationHandle.NULL_HANDLE;
    }

    @Override
    public void destroy() {
    }

    private class P_NullSubscription
    implements ISubscription {
        private final IDestination<?> m_destination;
        private final IMessageListener<?> m_messageListener;
        private final IRequestListener<?, ?> m_requestListener;
        private final SubscribeInput m_input;

        P_NullSubscription(IDestination<?> destination, IMessageListener<?> messageListener, IRequestListener<?, ?> requestListener, SubscribeInput input) {
            this.m_destination = destination;
            this.m_messageListener = messageListener;
            this.m_requestListener = requestListener;
            this.m_input = input;
        }

        @Override
        public IDestination<?> getDestination() {
            return this.m_destination;
        }

        @Override
        public IMessageListener<?> getMessageListener() {
            return this.m_messageListener;
        }

        @Override
        public IRequestListener<?, ?> getRequestListener() {
            return this.m_requestListener;
        }

        @Override
        public SubscribeInput getSubscribeInput() {
            return this.m_input;
        }

        @Override
        public void dispose() {
        }

        @Override
        public boolean isDisposed() {
            return false;
        }

        @Override
        public ISubscriptionStats getStats() {
            return null;
        }
    }
}

