/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.mom.api;

import java.util.List;
import org.eclipse.scout.rt.mom.api.AbstractDestinationConfigProperty;
import org.eclipse.scout.rt.mom.api.IBiDestination;
import org.eclipse.scout.rt.mom.api.IDestination;
import org.eclipse.scout.rt.mom.api.IMessageListener;
import org.eclipse.scout.rt.mom.api.IRequestListener;
import org.eclipse.scout.rt.mom.api.ISubscription;
import org.eclipse.scout.rt.mom.api.MOM;
import org.eclipse.scout.rt.mom.api.PublishInput;
import org.eclipse.scout.rt.mom.api.SubscribeInput;
import org.eclipse.scout.rt.mom.api.marshaller.IMarshaller;
import org.eclipse.scout.rt.mom.api.marshaller.JsonDataObjectMarshaller;
import org.eclipse.scout.rt.platform.config.AbstractBooleanConfigProperty;
import org.eclipse.scout.rt.platform.config.AbstractClassConfigProperty;
import org.eclipse.scout.rt.platform.config.AbstractIntegerConfigProperty;
import org.eclipse.scout.rt.platform.util.IRegistrationHandle;

public interface IMom {
    public static final long DESTROY_ORDER = 5700L;

    public String getId();

    public String getName();

    public List<ISubscription> getSubscriptions();

    public <DTO> void publish(IDestination<DTO> var1, DTO var2, PublishInput var3);

    public <DTO> ISubscription subscribe(IDestination<DTO> var1, IMessageListener<DTO> var2, SubscribeInput var3);

    public <REQUEST, REPLY> REPLY request(IBiDestination<REQUEST, REPLY> var1, REQUEST var2, PublishInput var3);

    public <REQUEST, REPLY> ISubscription reply(IBiDestination<REQUEST, REPLY> var1, IRequestListener<REQUEST, REPLY> var2, SubscribeInput var3);

    public void cancelDurableSubscription(String var1);

    public IRegistrationHandle registerMarshaller(IDestination<?> var1, IMarshaller var2);

    public void destroy();

    public static class ConnectionRetryCountProperty
    extends AbstractIntegerConfigProperty {
        public String getKey() {
            return "scout.mom.failover.connectionRetryCount";
        }

        public String description() {
            return "Specifies the connection retry count for connection failover. Default is 15. The value 0 disables connection failover.";
        }

        public Integer getDefaultValue() {
            return 15;
        }
    }

    public static class ConnectionRetryIntervalMillisProperty
    extends AbstractIntegerConfigProperty {
        public String getKey() {
            return "scout.mom.failover.connectionRetryIntervalMillis";
        }

        public String description() {
            return "Specifies the connection retry interval in milliseconds. Default is 2000ms.";
        }

        public Integer getDefaultValue() {
            return 2000;
        }
    }

    public static class DefaultMarshallerProperty
    extends AbstractClassConfigProperty<IMarshaller> {
        public String getKey() {
            return "scout.mom.marshaller";
        }

        public String description() {
            return String.format("Specifies the default Marshaller to use if no marshaller is specified for a MOM or a destination. By default the '%s' is used.", JsonDataObjectMarshaller.class.getSimpleName());
        }

        public Class<? extends IMarshaller> getDefaultValue() {
            return JsonDataObjectMarshaller.class;
        }
    }

    public static class RequestReplyCancellationTopicProperty
    extends AbstractDestinationConfigProperty<String> {
        public String getKey() {
            return "scout.mom.requestreply.cancellationTopic";
        }

        public String description() {
            return "Specifies the default topic to receive cancellation request for 'request-reply' communication. By default, a defined topic with the name 'scout.mom.requestreply.cancellation' is used.";
        }

        public IDestination<String> getDefaultValue() {
            return MOM.newDestination("scout.mom.requestreply.cancellation", this.getType(), IDestination.ResolveMethod.DEFINE, null);
        }

        @Override
        protected IDestination.IDestinationType getType() {
            return IDestination.DestinationType.TOPIC;
        }
    }

    public static class RequestReplyEnabledProperty
    extends AbstractBooleanConfigProperty {
        public String getKey() {
            return "scout.mom.requestreply.enabled";
        }

        public String description() {
            return "Specifies if 'request-reply' messaging is enabled by default. This value can also be configured individually per MOM. The default value is true.";
        }

        public Boolean getDefaultValue() {
            return Boolean.TRUE;
        }
    }

    public static class SessionRetryIntervalMillisProperty
    extends AbstractIntegerConfigProperty {
        public String getKey() {
            return "scout.mom.failover.sessionRetryIntervalMillis";
        }

        public String description() {
            return "Specifies the session retry interval in milliseconds. Default is 5000ms.";
        }

        public Integer getDefaultValue() {
            return 5000;
        }
    }
}

