/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.jackson.dataobject.id;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import java.io.IOException;
import org.eclipse.scout.rt.dataobject.id.IId;
import org.eclipse.scout.rt.dataobject.id.IdCodec;
import org.eclipse.scout.rt.jackson.dataobject.ScoutDataObjectModuleContext;
import org.eclipse.scout.rt.jackson.dataobject.id.AbstractIdCodecDeserializer;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.ObjectUtility;

public class QualifiedIIdDeserializer
extends AbstractIdCodecDeserializer<IId> {
    private static final long serialVersionUID = 1L;
    protected final Class<? extends IId> m_idClass;

    public QualifiedIIdDeserializer(ScoutDataObjectModuleContext moduleContext, Class<? extends IId> idClass) {
        super(moduleContext, idClass);
        this.m_idClass = idClass;
    }

    public IId deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        String rawValue = p.getText();
        try {
            IId id = this.idCodec().fromQualified(rawValue, this.idCodecFlags());
            if (!ObjectUtility.isOneOf((Object)IdCodec.IdCodecFlag.LENIENT, this.idCodecFlags())) {
                Assertions.assertInstance((Object)id, this.m_idClass);
            }
            return id;
        }
        catch (RuntimeException e) {
            throw InvalidFormatException.from((JsonParser)p, (String)("Failed to deserialize qualified IId: " + e.getMessage()), (Object)rawValue, this.m_idClass);
        }
    }
}

