/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.jackson.dataobject.enumeration;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import java.io.IOException;
import org.eclipse.scout.rt.dataobject.enumeration.EnumResolver;
import org.eclipse.scout.rt.dataobject.enumeration.IEnum;
import org.eclipse.scout.rt.platform.util.LazyValue;

public class EnumDeserializer
extends StdDeserializer<IEnum> {
    private static final long serialVersionUID = 1L;
    protected final Class<? extends IEnum> m_enumType;
    protected final LazyValue<EnumResolver> m_enumResolver = new LazyValue(EnumResolver.class);

    public EnumDeserializer(Class<? extends IEnum> enumType) {
        super(enumType);
        this.m_enumType = enumType;
    }

    public IEnum deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        String rawValue = (String)p.readValueAs(String.class);
        try {
            return ((EnumResolver)this.m_enumResolver.get()).resolve(this.m_enumType, rawValue);
        }
        catch (RuntimeException e) {
            throw InvalidFormatException.from((JsonParser)p, (String)("Failed to deserialize IEnum: " + e.getMessage()), (Object)rawValue, this.m_enumType);
        }
    }
}

