/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.jackson.dataobject;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.ReferenceType;
import java.util.Collection;
import java.util.Currency;
import java.util.Date;
import java.util.Locale;
import org.eclipse.scout.rt.dataobject.DoCollection;
import org.eclipse.scout.rt.dataobject.DoList;
import org.eclipse.scout.rt.dataobject.DoSet;
import org.eclipse.scout.rt.dataobject.DoValue;
import org.eclipse.scout.rt.dataobject.IDataObject;
import org.eclipse.scout.rt.dataobject.IDoEntity;
import org.eclipse.scout.rt.dataobject.enumeration.IEnum;
import org.eclipse.scout.rt.dataobject.id.IId;
import org.eclipse.scout.rt.jackson.dataobject.CurrencyMapKeyDeserializer;
import org.eclipse.scout.rt.jackson.dataobject.DataObjectDeserializer;
import org.eclipse.scout.rt.jackson.dataobject.DoBinaryResourceDeserializer;
import org.eclipse.scout.rt.jackson.dataobject.DoBinaryResourceSerializer;
import org.eclipse.scout.rt.jackson.dataobject.DoCollectionDeserializer;
import org.eclipse.scout.rt.jackson.dataobject.DoCollectionSerializer;
import org.eclipse.scout.rt.jackson.dataobject.DoCurrencyDeserializer;
import org.eclipse.scout.rt.jackson.dataobject.DoDateDeserializer;
import org.eclipse.scout.rt.jackson.dataobject.DoDateSerializer;
import org.eclipse.scout.rt.jackson.dataobject.DoEntityDeserializer;
import org.eclipse.scout.rt.jackson.dataobject.DoEntitySerializer;
import org.eclipse.scout.rt.jackson.dataobject.DoLocaleDeserializer;
import org.eclipse.scout.rt.jackson.dataobject.DoLocaleSerializer;
import org.eclipse.scout.rt.jackson.dataobject.DoValueDeserializer;
import org.eclipse.scout.rt.jackson.dataobject.DoValueSerializer;
import org.eclipse.scout.rt.jackson.dataobject.IDataObjectSerializerProvider;
import org.eclipse.scout.rt.jackson.dataobject.LocaleMapKeyDeserializer;
import org.eclipse.scout.rt.jackson.dataobject.LocaleMapKeySerializer;
import org.eclipse.scout.rt.jackson.dataobject.ScoutDataObjectModuleContext;
import org.eclipse.scout.rt.jackson.dataobject.enumeration.EnumDeserializer;
import org.eclipse.scout.rt.jackson.dataobject.enumeration.EnumMapKeyDeserializer;
import org.eclipse.scout.rt.jackson.dataobject.enumeration.EnumMapKeySerializer;
import org.eclipse.scout.rt.jackson.dataobject.enumeration.EnumSerializer;
import org.eclipse.scout.rt.jackson.dataobject.id.QualifiedIIdDeserializer;
import org.eclipse.scout.rt.jackson.dataobject.id.QualifiedIIdMapKeyDeserializer;
import org.eclipse.scout.rt.jackson.dataobject.id.QualifiedIIdMapKeySerializer;
import org.eclipse.scout.rt.jackson.dataobject.id.QualifiedIIdSerializer;
import org.eclipse.scout.rt.jackson.dataobject.id.UnqualifiedIIdDeserializer;
import org.eclipse.scout.rt.jackson.dataobject.id.UnqualifiedIIdMapKeyDeserializer;
import org.eclipse.scout.rt.jackson.dataobject.id.UnqualifiedIIdMapKeySerializer;
import org.eclipse.scout.rt.jackson.dataobject.id.UnqualifiedIIdSerializer;
import org.eclipse.scout.rt.platform.resource.BinaryResource;
import org.eclipse.scout.rt.platform.util.ObjectUtility;

public class ScoutDataObjectSerializerProvider
implements IDataObjectSerializerProvider {
    @Override
    public JsonSerializer<?> findSerializer(ScoutDataObjectModuleContext moduleContext, JavaType type, SerializationConfig config, BeanDescription beanDesc) {
        Class rawClass = type.getRawClass();
        if (IDoEntity.class.isAssignableFrom(rawClass)) {
            return new DoEntitySerializer(moduleContext, type);
        }
        if (ObjectUtility.isOneOf((Object)rawClass, DoList.class, (Object[])new Object[]{DoSet.class, DoCollection.class})) {
            return new DoCollectionSerializer(moduleContext, type);
        }
        if (Date.class.isAssignableFrom(rawClass)) {
            return new DoDateSerializer();
        }
        if (Locale.class.isAssignableFrom(rawClass)) {
            return new DoLocaleSerializer();
        }
        if (BinaryResource.class.isAssignableFrom(rawClass)) {
            return new DoBinaryResourceSerializer();
        }
        if (IId.class.isAssignableFrom(rawClass)) {
            if (type.isConcrete()) {
                return new UnqualifiedIIdSerializer(moduleContext, type);
            }
            return new QualifiedIIdSerializer(moduleContext);
        }
        if (IEnum.class.isAssignableFrom(rawClass)) {
            return new EnumSerializer(type);
        }
        return null;
    }

    @Override
    public JsonDeserializer<?> findDeserializer(ScoutDataObjectModuleContext moduleContext, JavaType type, DeserializationConfig config, BeanDescription beanDesc) {
        Class rawClass = type.getRawClass();
        if (IDoEntity.class.isAssignableFrom(rawClass)) {
            return new DoEntityDeserializer(moduleContext, type);
        }
        if (DoList.class.isAssignableFrom(rawClass)) {
            return new DoCollectionDeserializer(type, DoList::new);
        }
        if (DoSet.class.isAssignableFrom(rawClass)) {
            return new DoCollectionDeserializer(type, DoSet::new);
        }
        if (DoCollection.class.isAssignableFrom(rawClass)) {
            return new DoCollectionDeserializer(type, DoCollection::new);
        }
        if (Date.class.isAssignableFrom(rawClass)) {
            return new DoDateDeserializer();
        }
        if (IDataObject.class.isAssignableFrom(rawClass)) {
            return new DataObjectDeserializer(type.getRawClass());
        }
        if (Locale.class.isAssignableFrom(rawClass)) {
            return new DoLocaleDeserializer();
        }
        if (Currency.class.isAssignableFrom(rawClass)) {
            return new DoCurrencyDeserializer();
        }
        if (BinaryResource.class.isAssignableFrom(rawClass)) {
            return new DoBinaryResourceDeserializer();
        }
        if (IId.class.isAssignableFrom(rawClass)) {
            Class<IId> idClass = rawClass.asSubclass(IId.class);
            if (type.isConcrete()) {
                return new UnqualifiedIIdDeserializer(moduleContext, (Class<? extends IId>)idClass);
            }
            return new QualifiedIIdDeserializer(moduleContext, (Class<? extends IId>)idClass);
        }
        return null;
    }

    @Override
    public JsonSerializer<?> findKeySerializer(ScoutDataObjectModuleContext moduleContext, JavaType type, SerializationConfig config, BeanDescription beanDesc) {
        Class rawClass = type.getRawClass();
        if (Locale.class.isAssignableFrom(rawClass)) {
            return new LocaleMapKeySerializer();
        }
        if (IId.class.isAssignableFrom(rawClass)) {
            if (type.isConcrete()) {
                return new UnqualifiedIIdMapKeySerializer(moduleContext);
            }
            return new QualifiedIIdMapKeySerializer(moduleContext);
        }
        if (IEnum.class.isAssignableFrom(rawClass)) {
            return new EnumMapKeySerializer();
        }
        return null;
    }

    @Override
    public KeyDeserializer findKeyDeserializer(ScoutDataObjectModuleContext moduleContext, JavaType type, DeserializationConfig config, BeanDescription beanDesc) {
        Class rawClass = type.getRawClass();
        if (Locale.class.isAssignableFrom(rawClass)) {
            return new LocaleMapKeyDeserializer();
        }
        if (Currency.class.isAssignableFrom(rawClass)) {
            return new CurrencyMapKeyDeserializer();
        }
        if (IId.class.isAssignableFrom(rawClass)) {
            Class<IId> idClass = rawClass.asSubclass(IId.class);
            if (type.isConcrete()) {
                return new UnqualifiedIIdMapKeyDeserializer(moduleContext, idClass);
            }
            return new QualifiedIIdMapKeyDeserializer(moduleContext, idClass);
        }
        if (IEnum.class.isAssignableFrom(rawClass)) {
            Class<IEnum> enumClass = rawClass.asSubclass(IEnum.class);
            return new EnumMapKeyDeserializer(moduleContext, enumClass);
        }
        return null;
    }

    @Override
    public JsonSerializer<?> findReferenceSerializer(ScoutDataObjectModuleContext moduleContext, ReferenceType refType, SerializationConfig config, BeanDescription beanDesc, TypeSerializer contentTypeSerializer, JsonSerializer<Object> contentValueSerializer) {
        if (DoValue.class.isAssignableFrom(refType.getRawClass())) {
            boolean staticTyping = contentTypeSerializer == null && config.isEnabled(MapperFeature.USE_STATIC_TYPING);
            return new DoValueSerializer(refType, staticTyping, contentTypeSerializer, contentValueSerializer);
        }
        return null;
    }

    @Override
    public JsonDeserializer<?> findReferenceDeserializer(ScoutDataObjectModuleContext moduleContext, ReferenceType refType, DeserializationConfig config, BeanDescription beanDesc, TypeDeserializer contentTypeDeserializer, JsonDeserializer<?> contentDeserializer) {
        if (refType.hasRawClass(DoValue.class)) {
            return new DoValueDeserializer((JavaType)refType, null, contentTypeDeserializer, contentDeserializer);
        }
        return null;
    }

    @Override
    public JsonSerializer<?> findCollectionSerializer(ScoutDataObjectModuleContext moduleContext, CollectionType type, SerializationConfig config, BeanDescription beanDesc, TypeSerializer elementTypeSerializer, JsonSerializer<Object> elementValueSerializer) {
        if (Collection.class.isAssignableFrom(type.getRawClass())) {
            return new DoCollectionSerializer(moduleContext, (JavaType)type);
        }
        return null;
    }

    @Override
    public JsonDeserializer<?> findEnumDeserializer(ScoutDataObjectModuleContext moduleContext, Class<?> type, DeserializationConfig config, BeanDescription beanDesc) {
        if (IEnum.class.isAssignableFrom(type)) {
            return new EnumDeserializer(type.asSubclass(IEnum.class));
        }
        return null;
    }
}

