/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.jackson.dataobject;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.scout.rt.jackson.dataobject.DoEntitySerializerAttributeNameComparator;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Bean;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.BooleanUtility;
import org.eclipse.scout.rt.platform.util.LazyValue;

@Bean
public class ScoutDataObjectModuleContext {
    protected static final String TYPE_ATTRIBUTE_NAME_KEY = "typeAttributeNameKey";
    protected static final String TYPE_VERSION_ATTRIBUTE_NAME_KEY = "typeVersionAttributeNameKey";
    protected static final String IGNORE_TYPE_ATTRIBUTE_KEY = "ignoreTypeAttributeKey";
    protected static final String SUPPRESS_TYPE_ATTRIBUTE_KEY = "suppressTypeAttributeKey";
    protected static final String CONTRIBUTIONS_ATTRIBUTE_NAME_KEY = "contributionsAttributeNameKey";
    protected static final String LENIENT_MODE_KEY = "lenientModeKey";
    protected static final String ID_SIGNATURE_KEY = "idSignatureKey";
    protected LazyValue<DoEntitySerializerAttributeNameComparator> m_comparator = new LazyValue(() -> ((DoEntitySerializerAttributeNameComparator)BEANS.get(DoEntitySerializerAttributeNameComparator.class)).init(this));
    protected final Map<String, Object> m_contextMap = new HashMap<String, Object>();

    public void put(String key, Object value) {
        this.m_contextMap.put(key, value);
    }

    public Object get(String key) {
        return this.m_contextMap.get(key);
    }

    public <T> T get(String key, Class<T> clazz) {
        return (T)Assertions.assertType((Object)this.get(key), clazz);
    }

    public DoEntitySerializerAttributeNameComparator getComparator() {
        return (DoEntitySerializerAttributeNameComparator)this.m_comparator.get();
    }

    public String getTypeAttributeName() {
        return this.get(TYPE_ATTRIBUTE_NAME_KEY, String.class);
    }

    public ScoutDataObjectModuleContext withTypeAttributeName(String typeAttributeName) {
        this.put(TYPE_ATTRIBUTE_NAME_KEY, typeAttributeName);
        return this;
    }

    public String getTypeVersionAttributeName() {
        return this.get(TYPE_VERSION_ATTRIBUTE_NAME_KEY, String.class);
    }

    public ScoutDataObjectModuleContext withTypeVersionAttributeName(String typeVersionAttributeName) {
        this.put(TYPE_VERSION_ATTRIBUTE_NAME_KEY, typeVersionAttributeName);
        return this;
    }

    public boolean isIgnoreTypeAttribute() {
        return BooleanUtility.nvl((Boolean)this.get(IGNORE_TYPE_ATTRIBUTE_KEY, Boolean.class));
    }

    public ScoutDataObjectModuleContext withIgnoreTypeAttribute(boolean ignoreTypeAttribute) {
        this.put(IGNORE_TYPE_ATTRIBUTE_KEY, ignoreTypeAttribute);
        return this;
    }

    public boolean isSuppressTypeAttribute() {
        return BooleanUtility.nvl((Boolean)this.get(SUPPRESS_TYPE_ATTRIBUTE_KEY, Boolean.class));
    }

    public ScoutDataObjectModuleContext withSuppressTypeAttribute(boolean suppressTypeAttribute) {
        this.put(SUPPRESS_TYPE_ATTRIBUTE_KEY, suppressTypeAttribute);
        return this;
    }

    public String getContributionsAttributeName() {
        return this.get(CONTRIBUTIONS_ATTRIBUTE_NAME_KEY, String.class);
    }

    public ScoutDataObjectModuleContext withContributionsAttributeName(String contributionsAttributeName) {
        this.put(CONTRIBUTIONS_ATTRIBUTE_NAME_KEY, contributionsAttributeName);
        return this;
    }

    public boolean isLenientMode() {
        return BooleanUtility.nvl((Boolean)this.get(LENIENT_MODE_KEY, Boolean.class));
    }

    public ScoutDataObjectModuleContext withLenientMode(boolean lenientMode) {
        this.put(LENIENT_MODE_KEY, lenientMode);
        return this;
    }

    public boolean isIdSignature() {
        return BooleanUtility.nvl((Boolean)this.get(ID_SIGNATURE_KEY, Boolean.class));
    }

    public ScoutDataObjectModuleContext withIdSignature(boolean idSignature) {
        this.put(ID_SIGNATURE_KEY, idSignature);
        return this;
    }
}

