/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.jackson.dataobject;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.core.util.JsonParserSequence;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.TokenBuffer;
import java.io.IOException;
import java.math.BigDecimal;
import org.eclipse.scout.rt.dataobject.AbstractDoCollection;
import org.eclipse.scout.rt.dataobject.DoEntity;
import org.eclipse.scout.rt.dataobject.DoList;
import org.eclipse.scout.rt.dataobject.DoMapEntity;
import org.eclipse.scout.rt.dataobject.DoNode;
import org.eclipse.scout.rt.dataobject.IDataObject;
import org.eclipse.scout.rt.dataobject.IDoCollection;
import org.eclipse.scout.rt.dataobject.IDoEntity;
import org.eclipse.scout.rt.jackson.dataobject.AttributeType;
import org.eclipse.scout.rt.jackson.dataobject.DefaultDoEntityDeserializerTypeStrategy;
import org.eclipse.scout.rt.jackson.dataobject.IDoEntityDeserializerTypeStrategy;
import org.eclipse.scout.rt.jackson.dataobject.RawDoEntityDeserializerTypeStrategy;
import org.eclipse.scout.rt.jackson.dataobject.ScoutDataObjectModuleContext;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;

public class DoEntityDeserializer
extends StdDeserializer<IDoEntity> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(DoEntityDeserializer.class);
    protected final ScoutDataObjectModuleContext m_moduleContext;
    protected final JavaType m_handledType;
    protected final Class<? extends IDoEntity> m_handledClass;
    protected final IDoEntityDeserializerTypeStrategy m_doEntityDeserializerTypeStrategy;

    public DoEntityDeserializer(ScoutDataObjectModuleContext moduleContext, JavaType type) {
        super(type);
        this.m_moduleContext = moduleContext;
        this.m_handledType = type;
        this.m_handledClass = type.getRawClass().asSubclass(IDoEntity.class);
        this.m_doEntityDeserializerTypeStrategy = this.initDoEntityTypeStrategy(moduleContext);
    }

    protected IDoEntityDeserializerTypeStrategy initDoEntityTypeStrategy(ScoutDataObjectModuleContext moduleContext) {
        if (moduleContext.isIgnoreTypeAttribute()) {
            return (IDoEntityDeserializerTypeStrategy)BEANS.get(RawDoEntityDeserializerTypeStrategy.class);
        }
        return (IDoEntityDeserializerTypeStrategy)BEANS.get(DefaultDoEntityDeserializerTypeStrategy.class);
    }

    public IDoEntity deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        return this.deserializeDoEntity(p, ctxt, null);
    }

    public IDoEntity deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        return this.deserializeDoEntity(p, ctxt, typeDeserializer);
    }

    protected IDoEntity deserializeDoEntity(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        switch (p.nextToken()) {
            case FIELD_NAME: {
                return this.deserializeDoEntityAttributes(p, ctxt);
            }
            case END_OBJECT: {
                return this.newObject(ctxt, this.m_handledClass);
            }
        }
        throw ctxt.wrongTokenException(p, this.m_handledType, JsonToken.FIELD_NAME, null);
    }

    protected IDoEntity deserializeDoEntityAttributes(JsonParser p, DeserializationContext ctxt) throws IOException {
        TokenBuffer tb = null;
        JsonToken t = p.currentToken();
        while (t == JsonToken.FIELD_NAME) {
            String attributeName = p.getCurrentName();
            p.nextToken();
            if (this.m_moduleContext.getTypeAttributeName().equals(attributeName)) {
                String entityType = p.getText();
                IDoEntity entity = this.resolveEntityType(ctxt, entityType);
                p.setCurrentValue((Object)entity);
                if (tb != null) {
                    p.clearCurrentToken();
                    JsonParser tbParser = tb.asParser(p);
                    tbParser.setCurrentValue((Object)entity);
                    p = JsonParserSequence.createFlattened((boolean)false, (JsonParser)tbParser, (JsonParser)p);
                }
                p.nextToken();
                return this.deserializeDoEntityAttributes(p, ctxt, entity);
            }
            if (tb == null) {
                tb = new TokenBuffer(p, ctxt);
            }
            tb.writeFieldName(attributeName);
            tb.copyCurrentStructure(p);
            t = p.nextToken();
        }
        if (tb != null) {
            tb.writeEndObject();
            p = tb.asParser(p);
            p.nextToken();
        }
        IDoEntity entity = this.resolveEntityType(ctxt, null);
        p.setCurrentValue((Object)entity);
        return this.deserializeDoEntityAttributes(p, ctxt, entity);
    }

    protected IDoEntity deserializeDoEntityAttributes(JsonParser p, DeserializationContext ctxt, IDoEntity entity) throws IOException {
        JsonToken t = p.currentToken();
        while (t == JsonToken.FIELD_NAME) {
            String attributeName = p.getCurrentName();
            p.nextToken();
            if (this.m_moduleContext.getTypeVersionAttributeName().equals(attributeName)) {
                AttributeType at = AttributeType.ofDoValue(TypeFactory.defaultInstance().constructType(String.class));
                value = this.readAttributeValue(p, at, attributeName);
                this.deserializeDoEntityVersionAttribute(entity, attributeName, value);
            } else {
                AttributeType attributeType = this.findResolvedAttributeType(entity, attributeName, p.currentToken());
                if (attributeType.isDoCollection()) {
                    DoNode nodeValue = (DoNode)this.readAttributeValue(p, attributeType, attributeName);
                    if (this.m_moduleContext.getContributionsAttributeName().equals(attributeName)) {
                        this.m_doEntityDeserializerTypeStrategy.putContributions(entity, attributeName, ((AbstractDoCollection)nodeValue).get());
                    } else {
                        entity.putNode(attributeName, nodeValue);
                    }
                } else {
                    value = this.readAttributeValue(p, attributeType, attributeName);
                    if (value instanceof IDoCollection) {
                        value = ((IDoCollection)value).get();
                    }
                    entity.put(attributeName, value);
                }
            }
            t = p.nextToken();
        }
        return entity;
    }

    protected <T> T readAttributeValue(JsonParser p, AttributeType attributeType, String attributeName) throws IOException {
        try {
            return (T)p.getCodec().readValue(p, (ResolvedType)attributeType.getJavaType());
        }
        catch (InvalidFormatException e) {
            if (this.m_moduleContext.isLenientMode()) {
                return (T)e.getValue();
            }
            String msg = MessageFormatter.arrayFormat((String)"Failed to deserialize attribute '{}' of entity {}, value was {}", (Object[])new Object[]{attributeName, this.handledType().getName(), e.getValue()}).getMessage();
            InvalidFormatException ife = InvalidFormatException.from((JsonParser)p, (String)msg, (Object)e.getValue(), (Class)e.getTargetType());
            ife.addSuppressed((Throwable)e);
            throw ife;
        }
        catch (IOException e) {
            String msg = MessageFormatter.format((String)"Failed to deserialize attribute '{}' of entity {}", (Object)attributeName, (Object)this.handledType().getName()).getMessage();
            throw JsonMappingException.from((JsonParser)p, (String)msg, (Throwable)e);
        }
    }

    protected void deserializeDoEntityVersionAttribute(IDoEntity entity, String attributeName, Object version) {
        String dataObjectTypeVersion = this.m_doEntityDeserializerTypeStrategy.resolveTypeVersion(entity.getClass());
        if (dataObjectTypeVersion != null) {
            if (!dataObjectTypeVersion.equals(version)) {
                LOG.warn("Found version mismatch while deserializing DoEntity {}. Data object version (in class file) '{}', deserialized data version '{}'", new Object[]{entity.getClass().getName(), dataObjectTypeVersion, version});
            }
        } else {
            entity.put(attributeName, version);
        }
    }

    protected IDoEntity resolveEntityType(DeserializationContext ctxt, String entityType) throws IOException {
        if (entityType != null) {
            Class<? extends IDoEntity> clazz = this.m_doEntityDeserializerTypeStrategy.resolveTypeName(entityType);
            if (clazz != null) {
                if (!this.m_moduleContext.isLenientMode() && !this.m_handledClass.isAssignableFrom(clazz)) {
                    throw JsonMappingException.from((DeserializationContext)ctxt, (String)("Class resolved by parsed entity type is not assignable from class expected by deserializer. [entityType=" + entityType + " resolvedClass=" + clazz.getName() + " handledClassByDeserializer=" + String.valueOf(this.m_handledClass) + "]"));
                }
                return this.newObject(ctxt, clazz);
            }
            if (!this.m_moduleContext.isLenientMode() && !ObjectUtility.isOneOf(this.m_handledClass, DoEntity.class, (Object[])new Object[]{IDoEntity.class, IDataObject.class})) {
                throw JsonMappingException.from((DeserializationContext)ctxt, (String)("Could not resolve a class by parsed entity type and deserializer expect a concrete class to be created. [entityType=" + entityType + " handledClassByDeserializer=" + String.valueOf(this.m_handledClass) + "]"));
            }
            IDoEntity entity = this.newObject(ctxt, DoEntity.class);
            entity.put(this.m_moduleContext.getTypeAttributeName(), (Object)entityType);
            return entity;
        }
        return this.newObject(ctxt, this.m_handledClass);
    }

    protected AttributeType findResolvedAttributeType(IDoEntity entityInstance, String attributeName, JsonToken currentToken) {
        return this.m_doEntityDeserializerTypeStrategy.resolveAttributeType(entityInstance.getClass(), attributeName, currentToken).orElseGet(() -> this.findResolvedFallbackAttributeType(entityInstance, attributeName, currentToken));
    }

    protected AttributeType findResolvedFallbackAttributeType(IDoEntity entityInstance, String attributeName, JsonToken currentToken) {
        JavaType entityType;
        if (DoMapEntity.class.isAssignableFrom(this.m_handledClass) && (entityType = this.findResolvedDoMapEntityType()).getRawClass() != Object.class) {
            return AttributeType.ofDoValue(entityType);
        }
        if (currentToken == JsonToken.START_OBJECT) {
            return AttributeType.ofDoValue(TypeFactory.defaultInstance().constructType(DoEntity.class));
        }
        if (currentToken == JsonToken.START_ARRAY) {
            return AttributeType.ofDoCollection(TypeFactory.defaultInstance().constructType(DoList.class));
        }
        if (currentToken == JsonToken.VALUE_NUMBER_FLOAT) {
            return AttributeType.ofDoValue(TypeFactory.defaultInstance().constructType(BigDecimal.class));
        }
        return AttributeType.ofDoValue(TypeFactory.unknownType());
    }

    protected JavaType findResolvedDoMapEntityType() {
        JavaType type = this.m_handledType;
        while (type.getRawClass() != DoMapEntity.class) {
            if (type.getRawClass() == Object.class) {
                return TypeFactory.defaultInstance().constructType(DoEntity.class);
            }
            type = type.getSuperClass();
        }
        return type.getBindings().getBoundType(0);
    }

    protected IDoEntity newObject(DeserializationContext ctxt, Class<? extends IDoEntity> entityType) throws IOException {
        if (entityType == IDoEntity.class) {
            return (IDoEntity)BEANS.get(DoEntity.class);
        }
        if (BEANS.getBeanManager().isBean(entityType)) {
            if (this.m_moduleContext.isLenientMode() && BEANS.getBeanManager().uniqueBean(entityType) == null) {
                return (IDoEntity)BEANS.get(DoEntity.class);
            }
            return (IDoEntity)BEANS.get(entityType);
        }
        throw JsonMappingException.from((DeserializationContext)ctxt, (String)("Could not instantiate class, " + (entityType == null ? null : entityType.getName()) + " is not a Scout bean"));
    }
}

