/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.jackson.dataobject;

import com.fasterxml.jackson.core.JsonStreamContext;
import java.text.SimpleDateFormat;
import org.eclipse.scout.rt.dataobject.DataObjectAttributeDescriptor;
import org.eclipse.scout.rt.dataobject.DataObjectInventory;
import org.eclipse.scout.rt.dataobject.DoList;
import org.eclipse.scout.rt.dataobject.IDoEntity;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.util.LazyValue;
import org.eclipse.scout.rt.platform.util.date.StrictSimpleDateFormat;

@ApplicationScoped
public class DoDateSerializationHelper {
    protected final LazyValue<DataObjectInventory> m_dataObjectInventory = new LazyValue(DataObjectInventory.class);

    public SimpleDateFormat findFormatter(JsonStreamContext ctx) {
        if (ctx != null && ctx.getCurrentValue() instanceof DoList) {
            ctx = ctx.getParent();
        }
        if (ctx != null && ctx.getCurrentValue() != null && ctx.getCurrentName() != null && ctx.getCurrentValue() instanceof IDoEntity) {
            Class<IDoEntity> entityClass = ctx.getCurrentValue().getClass().asSubclass(IDoEntity.class);
            return this.lookupFormatter(entityClass, ctx.getCurrentName());
        }
        return null;
    }

    protected SimpleDateFormat lookupFormatter(Class<? extends IDoEntity> entityClass, String name) {
        String pattern = ((DataObjectInventory)this.m_dataObjectInventory.get()).getAttributeDescription(entityClass, name).flatMap(DataObjectAttributeDescriptor::getFormatPattern).orElse("yyyy-MM-dd HH:mm:ss.SSS");
        return new StrictSimpleDateFormat(pattern);
    }
}

